package physx.character;


public class PxCapsuleController extends PxController {

    protected PxCapsuleController() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCapsuleController wrapPointer(long address) {
        return address != 0L ? new PxCapsuleController(address) : null;
    }
    
    public static PxCapsuleController arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCapsuleController(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: float
     */
    public float getRadius() {
        checkNotNull();
        return _getRadius(address);
    }
    private static native float _getRadius(long address);

    /**
     * @param radius WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean setRadius(float radius) {
        checkNotNull();
        return _setRadius(address, radius);
    }
    private static native boolean _setRadius(long address, float radius);

    /**
     * @return WebIDL type: float
     */
    public float getHeight() {
        checkNotNull();
        return _getHeight(address);
    }
    private static native float _getHeight(long address);

    /**
     * @param height WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean setHeight(float height) {
        checkNotNull();
        return _setHeight(address, height);
    }
    private static native boolean _setHeight(long address, float height);

    /**
     * @return WebIDL type: {@link PxCapsuleClimbingModeEnum} [enum]
     */
    public PxCapsuleClimbingModeEnum getClimbingMode() {
        checkNotNull();
        return PxCapsuleClimbingModeEnum.forValue(_getClimbingMode(address));
    }
    private static native int _getClimbingMode(long address);

    /**
     * @param mode WebIDL type: {@link PxCapsuleClimbingModeEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean setClimbingMode(PxCapsuleClimbingModeEnum mode) {
        checkNotNull();
        return _setClimbingMode(address, mode.value);
    }
    private static native boolean _setClimbingMode(long address, int mode);

}
