package physx.character;

import physx.physics.PxActor;
import physx.physics.PxShape;

public class PxControllerBehaviorCallbackImpl extends SimpleControllerBehaviorCallback {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxControllerBehaviorCallbackImpl wrapPointer(long address) {
        return address != 0L ? new PxControllerBehaviorCallbackImpl(address) : null;
    }
    
    public static PxControllerBehaviorCallbackImpl arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxControllerBehaviorCallbackImpl(long address) {
        super(address);
    }

    protected PxControllerBehaviorCallbackImpl() {
        address = _PxControllerBehaviorCallbackImpl();
    }
    private native long _PxControllerBehaviorCallbackImpl();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private int _getShapeBehaviorFlags(long shape, long actor) {
        return getShapeBehaviorFlags(PxShape.wrapPointer(shape), PxActor.wrapPointer(actor));
    }

    /**
     * @param shape WebIDL type: {@link PxShape} [Const, Ref]
     * @param actor WebIDL type: {@link PxActor} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int getShapeBehaviorFlags(PxShape shape, PxActor actor) {
        return 0;
    }

    /*
     * Called from native code
     */
    private int _getControllerBehaviorFlags(long controller) {
        return getControllerBehaviorFlags(PxController.wrapPointer(controller));
    }

    /**
     * @param controller WebIDL type: {@link PxController} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int getControllerBehaviorFlags(PxController controller) {
        return 0;
    }

    /*
     * Called from native code
     */
    private int _getObstacleBehaviorFlags(long obstacle) {
        return getObstacleBehaviorFlags(PxObstacle.wrapPointer(obstacle));
    }

    /**
     * @param obstacle WebIDL type: {@link PxObstacle} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int getObstacleBehaviorFlags(PxObstacle obstacle) {
        return 0;
    }

}
