package physx.character;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.physics.PxMaterial;

public class PxControllerDesc extends NativeObject {

    protected PxControllerDesc() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxControllerDesc wrapPointer(long address) {
        return address != 0L ? new PxControllerDesc(address) : null;
    }
    
    public static PxControllerDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxControllerDesc(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: {@link PxExtendedVec3} [Value]
     */
    public PxExtendedVec3 getPosition() {
        checkNotNull();
        return PxExtendedVec3.wrapPointer(_getPosition(address));
    }
    private static native long _getPosition(long address);

    /**
     * @param value WebIDL type: {@link PxExtendedVec3} [Value]
     */
    public void setPosition(PxExtendedVec3 value) {
        checkNotNull();
        _setPosition(address, value.getAddress());
    }
    private static native void _setPosition(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getUpDirection() {
        checkNotNull();
        return PxVec3.wrapPointer(_getUpDirection(address));
    }
    private static native long _getUpDirection(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setUpDirection(PxVec3 value) {
        checkNotNull();
        _setUpDirection(address, value.getAddress());
    }
    private static native void _setUpDirection(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getSlopeLimit() {
        checkNotNull();
        return _getSlopeLimit(address);
    }
    private static native float _getSlopeLimit(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setSlopeLimit(float value) {
        checkNotNull();
        _setSlopeLimit(address, value);
    }
    private static native void _setSlopeLimit(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getInvisibleWallHeight() {
        checkNotNull();
        return _getInvisibleWallHeight(address);
    }
    private static native float _getInvisibleWallHeight(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setInvisibleWallHeight(float value) {
        checkNotNull();
        _setInvisibleWallHeight(address, value);
    }
    private static native void _setInvisibleWallHeight(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMaxJumpHeight() {
        checkNotNull();
        return _getMaxJumpHeight(address);
    }
    private static native float _getMaxJumpHeight(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMaxJumpHeight(float value) {
        checkNotNull();
        _setMaxJumpHeight(address, value);
    }
    private static native void _setMaxJumpHeight(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getContactOffset() {
        checkNotNull();
        return _getContactOffset(address);
    }
    private static native float _getContactOffset(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setContactOffset(float value) {
        checkNotNull();
        _setContactOffset(address, value);
    }
    private static native void _setContactOffset(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getStepOffset() {
        checkNotNull();
        return _getStepOffset(address);
    }
    private static native float _getStepOffset(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setStepOffset(float value) {
        checkNotNull();
        _setStepOffset(address, value);
    }
    private static native void _setStepOffset(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDensity() {
        checkNotNull();
        return _getDensity(address);
    }
    private static native float _getDensity(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDensity(float value) {
        checkNotNull();
        _setDensity(address, value);
    }
    private static native void _setDensity(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getScaleCoeff() {
        checkNotNull();
        return _getScaleCoeff(address);
    }
    private static native float _getScaleCoeff(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setScaleCoeff(float value) {
        checkNotNull();
        _setScaleCoeff(address, value);
    }
    private static native void _setScaleCoeff(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getVolumeGrowth() {
        checkNotNull();
        return _getVolumeGrowth(address);
    }
    private static native float _getVolumeGrowth(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setVolumeGrowth(float value) {
        checkNotNull();
        _setVolumeGrowth(address, value);
    }
    private static native void _setVolumeGrowth(long address, float value);

    /**
     * @return WebIDL type: {@link PxUserControllerHitReport}
     */
    public PxUserControllerHitReport getReportCallback() {
        checkNotNull();
        return PxUserControllerHitReport.wrapPointer(_getReportCallback(address));
    }
    private static native long _getReportCallback(long address);

    /**
     * @param value WebIDL type: {@link PxUserControllerHitReport}
     */
    public void setReportCallback(PxUserControllerHitReport value) {
        checkNotNull();
        _setReportCallback(address, value.getAddress());
    }
    private static native void _setReportCallback(long address, long value);

    /**
     * @return WebIDL type: {@link PxControllerBehaviorCallback}
     */
    public PxControllerBehaviorCallback getBehaviorCallback() {
        checkNotNull();
        return PxControllerBehaviorCallback.wrapPointer(_getBehaviorCallback(address));
    }
    private static native long _getBehaviorCallback(long address);

    /**
     * @param value WebIDL type: {@link PxControllerBehaviorCallback}
     */
    public void setBehaviorCallback(PxControllerBehaviorCallback value) {
        checkNotNull();
        _setBehaviorCallback(address, value.getAddress());
    }
    private static native void _setBehaviorCallback(long address, long value);

    /**
     * @return WebIDL type: {@link PxControllerNonWalkableModeEnum} [enum]
     */
    public PxControllerNonWalkableModeEnum getNonWalkableMode() {
        checkNotNull();
        return PxControllerNonWalkableModeEnum.forValue(_getNonWalkableMode(address));
    }
    private static native int _getNonWalkableMode(long address);

    /**
     * @param value WebIDL type: {@link PxControllerNonWalkableModeEnum} [enum]
     */
    public void setNonWalkableMode(PxControllerNonWalkableModeEnum value) {
        checkNotNull();
        _setNonWalkableMode(address, value.value);
    }
    private static native void _setNonWalkableMode(long address, int value);

    /**
     * @return WebIDL type: {@link PxMaterial}
     */
    public PxMaterial getMaterial() {
        checkNotNull();
        return PxMaterial.wrapPointer(_getMaterial(address));
    }
    private static native long _getMaterial(long address);

    /**
     * @param value WebIDL type: {@link PxMaterial}
     */
    public void setMaterial(PxMaterial value) {
        checkNotNull();
        _setMaterial(address, value.getAddress());
    }
    private static native void _setMaterial(long address, long value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getRegisterDeletionListener() {
        checkNotNull();
        return _getRegisterDeletionListener(address);
    }
    private static native boolean _getRegisterDeletionListener(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setRegisterDeletionListener(boolean value) {
        checkNotNull();
        _setRegisterDeletionListener(address, value);
    }
    private static native void _setRegisterDeletionListener(long address, boolean value);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

    /**
     * @return WebIDL type: {@link PxControllerShapeTypeEnum} [enum]
     */
    public PxControllerShapeTypeEnum getType() {
        checkNotNull();
        return PxControllerShapeTypeEnum.forValue(_getType(address));
    }
    private static native int _getType(long address);

}
