package physx.character;

import physx.NativeObject;
import physx.physics.PxFilterData;
import physx.physics.PxQueryFilterCallback;
import physx.physics.PxQueryFlags;

public class PxControllerFilters extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxControllerFilters wrapPointer(long address) {
        return address != 0L ? new PxControllerFilters(address) : null;
    }
    
    public static PxControllerFilters arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxControllerFilters(long address) {
        super(address);
    }

    // Constructors

    public PxControllerFilters() {
        address = _PxControllerFilters();
    }
    private static native long _PxControllerFilters();

    /**
     * @param filterData WebIDL type: {@link PxFilterData} [Const]
     */
    public PxControllerFilters(PxFilterData filterData) {
        address = _PxControllerFilters(filterData.getAddress());
    }
    private static native long _PxControllerFilters(long filterData);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxFilterData} [Const]
     */
    public PxFilterData getMFilterData() {
        checkNotNull();
        return PxFilterData.wrapPointer(_getMFilterData(address));
    }
    private static native long _getMFilterData(long address);

    /**
     * @param value WebIDL type: {@link PxFilterData} [Const]
     */
    public void setMFilterData(PxFilterData value) {
        checkNotNull();
        _setMFilterData(address, value.getAddress());
    }
    private static native void _setMFilterData(long address, long value);

    /**
     * @return WebIDL type: {@link PxQueryFilterCallback}
     */
    public PxQueryFilterCallback getMFilterCallback() {
        checkNotNull();
        return PxQueryFilterCallback.wrapPointer(_getMFilterCallback(address));
    }
    private static native long _getMFilterCallback(long address);

    /**
     * @param value WebIDL type: {@link PxQueryFilterCallback}
     */
    public void setMFilterCallback(PxQueryFilterCallback value) {
        checkNotNull();
        _setMFilterCallback(address, value.getAddress());
    }
    private static native void _setMFilterCallback(long address, long value);

    /**
     * @return WebIDL type: {@link PxQueryFlags} [Value]
     */
    public PxQueryFlags getMFilterFlags() {
        checkNotNull();
        return PxQueryFlags.wrapPointer(_getMFilterFlags(address));
    }
    private static native long _getMFilterFlags(long address);

    /**
     * @param value WebIDL type: {@link PxQueryFlags} [Value]
     */
    public void setMFilterFlags(PxQueryFlags value) {
        checkNotNull();
        _setMFilterFlags(address, value.getAddress());
    }
    private static native void _setMFilterFlags(long address, long value);

    /**
     * @return WebIDL type: {@link PxControllerFilterCallback}
     */
    public PxControllerFilterCallback getMCCTFilterCallback() {
        checkNotNull();
        return PxControllerFilterCallback.wrapPointer(_getMCCTFilterCallback(address));
    }
    private static native long _getMCCTFilterCallback(long address);

    /**
     * @param value WebIDL type: {@link PxControllerFilterCallback}
     */
    public void setMCCTFilterCallback(PxControllerFilterCallback value) {
        checkNotNull();
        _setMCCTFilterCallback(address, value.getAddress());
    }
    private static native void _setMCCTFilterCallback(long address, long value);

}
