package physx.character;

import physx.NativeObject;

public class PxObstacleContext extends NativeObject {

    protected PxObstacleContext() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxObstacleContext wrapPointer(long address) {
        return address != 0L ? new PxObstacleContext(address) : null;
    }
    
    public static PxObstacleContext arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxObstacleContext(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @return WebIDL type: {@link PxControllerManager} [Ref]
     */
    public PxControllerManager getControllerManager() {
        checkNotNull();
        return PxControllerManager.wrapPointer(_getControllerManager(address));
    }
    private static native long _getControllerManager(long address);

    /**
     * @param obstacle WebIDL type: {@link PxObstacle} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int addObstacle(PxObstacle obstacle) {
        checkNotNull();
        return _addObstacle(address, obstacle.getAddress());
    }
    private static native int _addObstacle(long address, long obstacle);

    /**
     * @param handle WebIDL type: unsigned long
     * @return WebIDL type: boolean
     */
    public boolean removeObstacle(int handle) {
        checkNotNull();
        return _removeObstacle(address, handle);
    }
    private static native boolean _removeObstacle(long address, int handle);

    /**
     * @param handle   WebIDL type: unsigned long
     * @param obstacle WebIDL type: {@link PxObstacle} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean updateObstacle(int handle, PxObstacle obstacle) {
        checkNotNull();
        return _updateObstacle(address, handle, obstacle.getAddress());
    }
    private static native boolean _updateObstacle(long address, int handle, long obstacle);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbObstacles() {
        checkNotNull();
        return _getNbObstacles(address);
    }
    private static native int _getNbObstacles(long address);

    /**
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: {@link PxObstacle} [Const]
     */
    public PxObstacle getObstacle(int i) {
        checkNotNull();
        return PxObstacle.wrapPointer(_getObstacle(address, i));
    }
    private static native long _getObstacle(long address, int i);

    /**
     * @param handle WebIDL type: unsigned long
     * @return WebIDL type: {@link PxObstacle} [Const]
     */
    public PxObstacle getObstacleByHandle(int handle) {
        checkNotNull();
        return PxObstacle.wrapPointer(_getObstacleByHandle(address, handle));
    }
    private static native long _getObstacleByHandle(long address, int handle);

}
