package physx.character;

import physx.NativeObject;

public class PxUserControllerHitReport extends NativeObject {

    protected PxUserControllerHitReport() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxUserControllerHitReport wrapPointer(long address) {
        return address != 0L ? new PxUserControllerHitReport(address) : null;
    }
    
    public static PxUserControllerHitReport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxUserControllerHitReport(long address) {
        super(address);
    }

    // Functions

    /**
     * @param hit WebIDL type: {@link PxControllerShapeHit} [Const, Ref]
     */
    public void onShapeHit(PxControllerShapeHit hit) {
        checkNotNull();
        _onShapeHit(address, hit.getAddress());
    }
    private static native void _onShapeHit(long address, long hit);

    /**
     * @param hit WebIDL type: {@link PxControllersHit} [Const, Ref]
     */
    public void onControllerHit(PxControllersHit hit) {
        checkNotNull();
        _onControllerHit(address, hit.getAddress());
    }
    private static native void _onControllerHit(long address, long hit);

    /**
     * @param hit WebIDL type: {@link PxControllerObstacleHit} [Const, Ref]
     */
    public void onObstacleHit(PxControllerObstacleHit hit) {
        checkNotNull();
        _onObstacleHit(address, hit.getAddress());
    }
    private static native void _onObstacleHit(long address, long hit);

}
