package physx.common;

import physx.NativeObject;

public class PxBase extends NativeObject {

    protected PxBase() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBase wrapPointer(long address) {
        return address != 0L ? new PxBase(address) : null;
    }
    
    public static PxBase arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBase(long address) {
        super(address);
    }

    // Functions

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @return WebIDL type: DOMString [Const]
     */
    public String getConcreteTypeName() {
        checkNotNull();
        return _getConcreteTypeName(address);
    }
    private static native String _getConcreteTypeName(long address);

    /**
     * @return WebIDL type: long
     */
    public int getConcreteType() {
        checkNotNull();
        return _getConcreteType(address);
    }
    private static native int _getConcreteType(long address);

    /**
     * @param flag  WebIDL type: {@link PxBaseFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setBaseFlag(PxBaseFlagEnum flag, boolean value) {
        checkNotNull();
        _setBaseFlag(address, flag.value, value);
    }
    private static native void _setBaseFlag(long address, int flag, boolean value);

    /**
     * @param inFlags WebIDL type: {@link PxBaseFlags} [Ref]
     */
    public void setBaseFlags(PxBaseFlags inFlags) {
        checkNotNull();
        _setBaseFlags(address, inFlags.getAddress());
    }
    private static native void _setBaseFlags(long address, long inFlags);

    /**
     * @return WebIDL type: {@link PxBaseFlags} [Value]
     */
    public PxBaseFlags getBaseFlags() {
        checkNotNull();
        return PxBaseFlags.wrapPointer(_getBaseFlags(address));
    }
    private static native long _getBaseFlags(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isReleasable() {
        checkNotNull();
        return _isReleasable(address);
    }
    private static native boolean _isReleasable(long address);

}
