package physx.common;


public class PxBoundedData extends PxStridedData {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBoundedData wrapPointer(long address) {
        return address != 0L ? new PxBoundedData(address) : null;
    }
    
    public static PxBoundedData arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBoundedData(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxBoundedData
     */
    public static PxBoundedData createAt(long address) {
        __placement_new_PxBoundedData(address);
        PxBoundedData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxBoundedData
     */
    public static <T> PxBoundedData createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxBoundedData(address);
        PxBoundedData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxBoundedData(long address);

    // Constructors

    public PxBoundedData() {
        address = _PxBoundedData();
    }
    private static native long _PxBoundedData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCount() {
        checkNotNull();
        return _getCount(address);
    }
    private static native int _getCount(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setCount(int value) {
        checkNotNull();
        _setCount(address, value);
    }
    private static native void _setCount(long address, int value);

}
