package physx.common;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxCudaContext extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.common.PxCudaContext");
    }

    protected PxCudaContext() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCudaContext wrapPointer(long address) {
        return address != 0L ? new PxCudaContext(address) : null;
    }
    
    public static PxCudaContext arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCudaContext(long address) {
        super(address);
    }

    // Functions

    /**
     * @param dstHost   WebIDL type: VoidPtr
     * @param srcDevice WebIDL type: unsigned long long
     * @param byteCount WebIDL type: unsigned long
     * @return WebIDL type: {@link PxCUresult}
     */
    public PxCUresult memcpyDtoH(NativeObject dstHost, long srcDevice, int byteCount) {
        checkNotNull();
        return PxCUresult.wrapPointer(_memcpyDtoH(address, dstHost.getAddress(), srcDevice, byteCount));
    }
    private static native long _memcpyDtoH(long address, long dstHost, long srcDevice, int byteCount);

    /**
     * @param dstDevice WebIDL type: unsigned long long
     * @param srcHost   WebIDL type: VoidPtr
     * @param byteCount WebIDL type: unsigned long
     * @return WebIDL type: {@link PxCUresult}
     */
    public PxCUresult memcpyHtoD(long dstDevice, NativeObject srcHost, int byteCount) {
        checkNotNull();
        return PxCUresult.wrapPointer(_memcpyHtoD(address, dstDevice, srcHost.getAddress(), byteCount));
    }
    private static native long _memcpyHtoD(long address, long dstDevice, long srcHost, int byteCount);

}
