package physx.common;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxCudaContextManager extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.common.PxCudaContextManager");
    }

    protected PxCudaContextManager() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCudaContextManager wrapPointer(long address) {
        return address != 0L ? new PxCudaContextManager(address) : null;
    }
    
    public static PxCudaContextManager arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCudaContextManager(long address) {
        super(address);
    }

    // Functions

    public void acquireContext() {
        checkNotNull();
        _acquireContext(address);
    }
    private static native void _acquireContext(long address);

    public void releaseContext() {
        checkNotNull();
        _releaseContext(address);
    }
    private static native void _releaseContext(long address);

    /**
     * @return WebIDL type: {@link CUcontext}
     */
    public CUcontext getContext() {
        checkNotNull();
        return CUcontext.wrapPointer(_getContext(address));
    }
    private static native long _getContext(long address);

    /**
     * @return WebIDL type: {@link PxCudaContext}
     */
    public PxCudaContext getCudaContext() {
        checkNotNull();
        return PxCudaContext.wrapPointer(_getCudaContext(address));
    }
    private static native long _getCudaContext(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean contextIsValid() {
        checkNotNull();
        return _contextIsValid(address);
    }
    private static native boolean _contextIsValid(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean supportsArchSM10() {
        checkNotNull();
        return _supportsArchSM10(address);
    }
    private static native boolean _supportsArchSM10(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean supportsArchSM11() {
        checkNotNull();
        return _supportsArchSM11(address);
    }
    private static native boolean _supportsArchSM11(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean supportsArchSM12() {
        checkNotNull();
        return _supportsArchSM12(address);
    }
    private static native boolean _supportsArchSM12(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean supportsArchSM13() {
        checkNotNull();
        return _supportsArchSM13(address);
    }
    private static native boolean _supportsArchSM13(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean supportsArchSM20() {
        checkNotNull();
        return _supportsArchSM20(address);
    }
    private static native boolean _supportsArchSM20(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean supportsArchSM30() {
        checkNotNull();
        return _supportsArchSM30(address);
    }
    private static native boolean _supportsArchSM30(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean supportsArchSM35() {
        checkNotNull();
        return _supportsArchSM35(address);
    }
    private static native boolean _supportsArchSM35(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean supportsArchSM50() {
        checkNotNull();
        return _supportsArchSM50(address);
    }
    private static native boolean _supportsArchSM50(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean supportsArchSM52() {
        checkNotNull();
        return _supportsArchSM52(address);
    }
    private static native boolean _supportsArchSM52(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean supportsArchSM60() {
        checkNotNull();
        return _supportsArchSM60(address);
    }
    private static native boolean _supportsArchSM60(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isIntegrated() {
        checkNotNull();
        return _isIntegrated(address);
    }
    private static native boolean _isIntegrated(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean canMapHostMemory() {
        checkNotNull();
        return _canMapHostMemory(address);
    }
    private static native boolean _canMapHostMemory(long address);

    /**
     * @return WebIDL type: long
     */
    public int getDriverVersion() {
        checkNotNull();
        return _getDriverVersion(address);
    }
    private static native int _getDriverVersion(long address);

    /**
     * @return WebIDL type: unsigned long long
     */
    public long getDeviceTotalMemBytes() {
        checkNotNull();
        return _getDeviceTotalMemBytes(address);
    }
    private static native long _getDeviceTotalMemBytes(long address);

    /**
     * @return WebIDL type: long
     */
    public int getMultiprocessorCount() {
        checkNotNull();
        return _getMultiprocessorCount(address);
    }
    private static native int _getMultiprocessorCount(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getClockRate() {
        checkNotNull();
        return _getClockRate(address);
    }
    private static native int _getClockRate(long address);

    /**
     * @return WebIDL type: long
     */
    public int getSharedMemPerBlock() {
        checkNotNull();
        return _getSharedMemPerBlock(address);
    }
    private static native int _getSharedMemPerBlock(long address);

    /**
     * @return WebIDL type: long
     */
    public int getSharedMemPerMultiprocessor() {
        checkNotNull();
        return _getSharedMemPerMultiprocessor(address);
    }
    private static native int _getSharedMemPerMultiprocessor(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxThreadsPerBlock() {
        checkNotNull();
        return _getMaxThreadsPerBlock(address);
    }
    private static native int _getMaxThreadsPerBlock(long address);

    /**
     * @return WebIDL type: DOMString [Const]
     */
    public String getDeviceName() {
        checkNotNull();
        return _getDeviceName(address);
    }
    private static native String _getDeviceName(long address);

    /**
     * @return WebIDL type: {@link CUdevice}
     */
    public CUdevice getDevice() {
        checkNotNull();
        return CUdevice.wrapPointer(_getDevice(address));
    }
    private static native long _getDevice(long address);

    /**
     * @param flag WebIDL type: boolean
     */
    public void setUsingConcurrentStreams(boolean flag) {
        checkNotNull();
        _setUsingConcurrentStreams(address, flag);
    }
    private static native void _setUsingConcurrentStreams(long address, boolean flag);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getUsingConcurrentStreams() {
        checkNotNull();
        return _getUsingConcurrentStreams(address);
    }
    private static native boolean _getUsingConcurrentStreams(long address);

    /**
     * @return WebIDL type: long
     */
    public int usingDedicatedGPU() {
        checkNotNull();
        return _usingDedicatedGPU(address);
    }
    private static native int _usingDedicatedGPU(long address);

    /**
     * @return WebIDL type: {@link CUmodule}
     */
    public CUmodule getCuModules() {
        checkNotNull();
        return CUmodule.wrapPointer(_getCuModules(address));
    }
    private static native long _getCuModules(long address);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

}
