package physx.common;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxCudaContextManagerDesc extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.common.PxCudaContextManagerDesc");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCudaContextManagerDesc wrapPointer(long address) {
        return address != 0L ? new PxCudaContextManagerDesc(address) : null;
    }
    
    public static PxCudaContextManagerDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCudaContextManagerDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxCudaContextManagerDesc
     */
    public static PxCudaContextManagerDesc createAt(long address) {
        __placement_new_PxCudaContextManagerDesc(address);
        PxCudaContextManagerDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxCudaContextManagerDesc
     */
    public static <T> PxCudaContextManagerDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxCudaContextManagerDesc(address);
        PxCudaContextManagerDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxCudaContextManagerDesc(long address);

    // Constructors

    public PxCudaContextManagerDesc() {
        address = _PxCudaContextManagerDesc();
    }
    private static native long _PxCudaContextManagerDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link CUcontext}
     */
    public CUcontext getCtx() {
        checkNotNull();
        return CUcontext.wrapPointer(_getCtx(address));
    }
    private static native long _getCtx(long address);

    /**
     * @param value WebIDL type: {@link CUcontext}
     */
    public void setCtx(CUcontext value) {
        checkNotNull();
        _setCtx(address, value.getAddress());
    }
    private static native void _setCtx(long address, long value);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getGraphicsDevice() {
        checkNotNull();
        return NativeObject.wrapPointer(_getGraphicsDevice(address));
    }
    private static native long _getGraphicsDevice(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setGraphicsDevice(NativeObject value) {
        checkNotNull();
        _setGraphicsDevice(address, value.getAddress());
    }
    private static native void _setGraphicsDevice(long address, long value);

    /**
     * @return WebIDL type: DOMString
     */
    public String getAppGUID() {
        checkNotNull();
        return _getAppGUID(address);
    }
    private static native String _getAppGUID(long address);

    /**
     * @param value WebIDL type: DOMString
     */
    public void setAppGUID(String value) {
        checkNotNull();
        _setAppGUID(address, value);
    }
    private static native void _setAppGUID(long address, String value);

}
