package physx.common;

import physx.NativeObject;

public class PxDebugTriangle extends NativeObject {

    protected PxDebugTriangle() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxDebugTriangle wrapPointer(long address) {
        return address != 0L ? new PxDebugTriangle(address) : null;
    }
    
    public static PxDebugTriangle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxDebugTriangle(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getPos0() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPos0(address));
    }
    private static native long _getPos0(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setPos0(PxVec3 value) {
        checkNotNull();
        _setPos0(address, value.getAddress());
    }
    private static native void _setPos0(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getColor0() {
        checkNotNull();
        return _getColor0(address);
    }
    private static native int _getColor0(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setColor0(int value) {
        checkNotNull();
        _setColor0(address, value);
    }
    private static native void _setColor0(long address, int value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getPos1() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPos1(address));
    }
    private static native long _getPos1(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setPos1(PxVec3 value) {
        checkNotNull();
        _setPos1(address, value.getAddress());
    }
    private static native void _setPos1(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getColor1() {
        checkNotNull();
        return _getColor1(address);
    }
    private static native int _getColor1(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setColor1(int value) {
        checkNotNull();
        _setColor1(address, value);
    }
    private static native void _setColor1(long address, int value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getPos2() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPos2(address));
    }
    private static native long _getPos2(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setPos2(PxVec3 value) {
        checkNotNull();
        _setPos2(address, value.getAddress());
    }
    private static native void _setPos2(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getColor2() {
        checkNotNull();
        return _getColor2(address);
    }
    private static native int _getColor2(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setColor2(int value) {
        checkNotNull();
        _setColor2(address, value);
    }
    private static native void _setColor2(long address, int value);

}
