package physx.common;


public class PxRefCounted extends PxBase {

    protected PxRefCounted() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxRefCounted wrapPointer(long address) {
        return address != 0L ? new PxRefCounted(address) : null;
    }
    
    public static PxRefCounted arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxRefCounted(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: unsigned long
     */
    public int getReferenceCount() {
        checkNotNull();
        return _getReferenceCount(address);
    }
    private static native int _getReferenceCount(long address);

    public void acquireReference() {
        checkNotNull();
        _acquireReference(address);
    }
    private static native void _acquireReference(long address);

}
