package physx.common;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxgDynamicsMemoryConfig extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.common.PxgDynamicsMemoryConfig");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxgDynamicsMemoryConfig wrapPointer(long address) {
        return address != 0L ? new PxgDynamicsMemoryConfig(address) : null;
    }
    
    public static PxgDynamicsMemoryConfig arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxgDynamicsMemoryConfig(long address) {
        super(address);
    }

    // Constructors

    public PxgDynamicsMemoryConfig() {
        address = _PxgDynamicsMemoryConfig();
    }
    private static native long _PxgDynamicsMemoryConfig();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTempBufferCapacity() {
        checkNotNull();
        return _getTempBufferCapacity(address);
    }
    private static native int _getTempBufferCapacity(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setTempBufferCapacity(int value) {
        checkNotNull();
        _setTempBufferCapacity(address, value);
    }
    private static native void _setTempBufferCapacity(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxRigidContactCount() {
        checkNotNull();
        return _getMaxRigidContactCount(address);
    }
    private static native int _getMaxRigidContactCount(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxRigidContactCount(int value) {
        checkNotNull();
        _setMaxRigidContactCount(address, value);
    }
    private static native void _setMaxRigidContactCount(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxRigidPatchCount() {
        checkNotNull();
        return _getMaxRigidPatchCount(address);
    }
    private static native int _getMaxRigidPatchCount(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxRigidPatchCount(int value) {
        checkNotNull();
        _setMaxRigidPatchCount(address, value);
    }
    private static native void _setMaxRigidPatchCount(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getHeapCapacity() {
        checkNotNull();
        return _getHeapCapacity(address);
    }
    private static native int _getHeapCapacity(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setHeapCapacity(int value) {
        checkNotNull();
        _setHeapCapacity(address, value);
    }
    private static native void _setHeapCapacity(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFoundLostPairsCapacity() {
        checkNotNull();
        return _getFoundLostPairsCapacity(address);
    }
    private static native int _getFoundLostPairsCapacity(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setFoundLostPairsCapacity(int value) {
        checkNotNull();
        _setFoundLostPairsCapacity(address, value);
    }
    private static native void _setFoundLostPairsCapacity(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFoundLostAggregatePairsCapacity() {
        checkNotNull();
        return _getFoundLostAggregatePairsCapacity(address);
    }
    private static native int _getFoundLostAggregatePairsCapacity(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setFoundLostAggregatePairsCapacity(int value) {
        checkNotNull();
        _setFoundLostAggregatePairsCapacity(address, value);
    }
    private static native void _setFoundLostAggregatePairsCapacity(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTotalAggregatePairsCapacity() {
        checkNotNull();
        return _getTotalAggregatePairsCapacity(address);
    }
    private static native int _getTotalAggregatePairsCapacity(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setTotalAggregatePairsCapacity(int value) {
        checkNotNull();
        _setTotalAggregatePairsCapacity(address, value);
    }
    private static native void _setTotalAggregatePairsCapacity(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxSoftBodyContacts() {
        checkNotNull();
        return _getMaxSoftBodyContacts(address);
    }
    private static native int _getMaxSoftBodyContacts(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxSoftBodyContacts(int value) {
        checkNotNull();
        _setMaxSoftBodyContacts(address, value);
    }
    private static native void _setMaxSoftBodyContacts(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxFemClothContacts() {
        checkNotNull();
        return _getMaxFemClothContacts(address);
    }
    private static native int _getMaxFemClothContacts(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxFemClothContacts(int value) {
        checkNotNull();
        _setMaxFemClothContacts(address, value);
    }
    private static native void _setMaxFemClothContacts(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxParticleContacts() {
        checkNotNull();
        return _getMaxParticleContacts(address);
    }
    private static native int _getMaxParticleContacts(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxParticleContacts(int value) {
        checkNotNull();
        _setMaxParticleContacts(address, value);
    }
    private static native void _setMaxParticleContacts(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCollisionStackSize() {
        checkNotNull();
        return _getCollisionStackSize(address);
    }
    private static native int _getCollisionStackSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setCollisionStackSize(int value) {
        checkNotNull();
        _setCollisionStackSize(address, value);
    }
    private static native void _setCollisionStackSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxHairContacts() {
        checkNotNull();
        return _getMaxHairContacts(address);
    }
    private static native int _getMaxHairContacts(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxHairContacts(int value) {
        checkNotNull();
        _setMaxHairContacts(address, value);
    }
    private static native void _setMaxHairContacts(long address, int value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
