package physx.cooking;

import physx.NativeObject;

public class PxBVH34MidphaseDesc extends NativeObject {

    protected PxBVH34MidphaseDesc() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBVH34MidphaseDesc wrapPointer(long address) {
        return address != 0L ? new PxBVH34MidphaseDesc(address) : null;
    }
    
    public static PxBVH34MidphaseDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBVH34MidphaseDesc(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNumPrimsPerLeaf() {
        checkNotNull();
        return _getNumPrimsPerLeaf(address);
    }
    private static native int _getNumPrimsPerLeaf(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNumPrimsPerLeaf(int value) {
        checkNotNull();
        _setNumPrimsPerLeaf(address, value);
    }
    private static native void _setNumPrimsPerLeaf(long address, int value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
