package physx.cooking;

import physx.common.PxU16StridedData;
import physx.geometry.PxSimpleTriangleMesh;

public class PxTriangleMeshDesc extends PxSimpleTriangleMesh {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxTriangleMeshDesc wrapPointer(long address) {
        return address != 0L ? new PxTriangleMeshDesc(address) : null;
    }
    
    public static PxTriangleMeshDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxTriangleMeshDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxTriangleMeshDesc
     */
    public static PxTriangleMeshDesc createAt(long address) {
        __placement_new_PxTriangleMeshDesc(address);
        PxTriangleMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxTriangleMeshDesc
     */
    public static <T> PxTriangleMeshDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTriangleMeshDesc(address);
        PxTriangleMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTriangleMeshDesc(long address);

    // Constructors

    public PxTriangleMeshDesc() {
        address = _PxTriangleMeshDesc();
    }
    private static native long _PxTriangleMeshDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxU16StridedData} [Value]
     */
    public PxU16StridedData getMaterialIndices() {
        checkNotNull();
        return PxU16StridedData.wrapPointer(_getMaterialIndices(address));
    }
    private static native long _getMaterialIndices(long address);

    /**
     * @param value WebIDL type: {@link PxU16StridedData} [Value]
     */
    public void setMaterialIndices(PxU16StridedData value) {
        checkNotNull();
        _setMaterialIndices(address, value.getAddress());
    }
    private static native void _setMaterialIndices(long address, long value);

}
