package physx.extensions;


public class CapsuleSupport extends Support {

    protected CapsuleSupport() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static CapsuleSupport wrapPointer(long address) {
        return address != 0L ? new CapsuleSupport(address) : null;
    }
    
    public static CapsuleSupport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected CapsuleSupport(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address    Pre-allocated memory, where the object is created.
     * @param radius     WebIDL type: float
     * @param halfHeight WebIDL type: float
     * @return Stack allocated object of CapsuleSupport
     */
    public static CapsuleSupport createAt(long address, float radius, float halfHeight) {
        __placement_new_CapsuleSupport(address, radius, halfHeight);
        CapsuleSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>        Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator  Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate   Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param radius     WebIDL type: float
     * @param halfHeight WebIDL type: float
     * @return Stack allocated object of CapsuleSupport
     */
    public static <T> CapsuleSupport createAt(T allocator, Allocator<T> allocate, float radius, float halfHeight) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_CapsuleSupport(address, radius, halfHeight);
        CapsuleSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_CapsuleSupport(long address, float radius, float halfHeight);

    // Constructors

    /**
     * @param radius     WebIDL type: float
     * @param halfHeight WebIDL type: float
     */
    public CapsuleSupport(float radius, float halfHeight) {
        address = _CapsuleSupport(radius, halfHeight);
    }
    private static native long _CapsuleSupport(float radius, float halfHeight);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getRadius() {
        checkNotNull();
        return _getRadius(address);
    }
    private static native float _getRadius(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRadius(float value) {
        checkNotNull();
        _setRadius(address, value);
    }
    private static native void _setRadius(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getHalfHeight() {
        checkNotNull();
        return _getHalfHeight(address);
    }
    private static native float _getHalfHeight(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setHalfHeight(float value) {
        checkNotNull();
        _setHalfHeight(address, value);
    }
    private static native void _setHalfHeight(long address, float value);

}
