package physx.extensions;

import physx.geometry.PxGeometry;

public class ConvexGeomSupport extends Support {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static ConvexGeomSupport wrapPointer(long address) {
        return address != 0L ? new ConvexGeomSupport(address) : null;
    }
    
    public static ConvexGeomSupport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected ConvexGeomSupport(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of ConvexGeomSupport
     */
    public static ConvexGeomSupport createAt(long address) {
        __placement_new_ConvexGeomSupport(address);
        ConvexGeomSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of ConvexGeomSupport
     */
    public static <T> ConvexGeomSupport createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_ConvexGeomSupport(address);
        ConvexGeomSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_ConvexGeomSupport(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param geom    WebIDL type: {@link PxGeometry} [Const, Ref]
     * @return Stack allocated object of ConvexGeomSupport
     */
    public static ConvexGeomSupport createAt(long address, PxGeometry geom) {
        __placement_new_ConvexGeomSupport(address, geom.getAddress());
        ConvexGeomSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param geom      WebIDL type: {@link PxGeometry} [Const, Ref]
     * @return Stack allocated object of ConvexGeomSupport
     */
    public static <T> ConvexGeomSupport createAt(T allocator, Allocator<T> allocate, PxGeometry geom) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_ConvexGeomSupport(address, geom.getAddress());
        ConvexGeomSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_ConvexGeomSupport(long address, long geom);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param geom    WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param margin  WebIDL type: float
     * @return Stack allocated object of ConvexGeomSupport
     */
    public static ConvexGeomSupport createAt(long address, PxGeometry geom, float margin) {
        __placement_new_ConvexGeomSupport(address, geom.getAddress(), margin);
        ConvexGeomSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param geom      WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param margin    WebIDL type: float
     * @return Stack allocated object of ConvexGeomSupport
     */
    public static <T> ConvexGeomSupport createAt(T allocator, Allocator<T> allocate, PxGeometry geom, float margin) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_ConvexGeomSupport(address, geom.getAddress(), margin);
        ConvexGeomSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_ConvexGeomSupport(long address, long geom, float margin);

    // Constructors

    public ConvexGeomSupport() {
        address = _ConvexGeomSupport();
    }
    private static native long _ConvexGeomSupport();

    /**
     * @param geom WebIDL type: {@link PxGeometry} [Const, Ref]
     */
    public ConvexGeomSupport(PxGeometry geom) {
        address = _ConvexGeomSupport(geom.getAddress());
    }
    private static native long _ConvexGeomSupport(long geom);

    /**
     * @param geom   WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param margin WebIDL type: float
     */
    public ConvexGeomSupport(PxGeometry geom, float margin) {
        address = _ConvexGeomSupport(geom.getAddress(), margin);
    }
    private static native long _ConvexGeomSupport(long geom, float margin);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
