package physx.extensions;

import physx.PlatformChecks;
import physx.common.PxQuat;
import physx.common.PxVec3;
import physx.geometry.PxConvexMesh;

public class ConvexMeshSupport extends Support {

    protected ConvexMeshSupport() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static ConvexMeshSupport wrapPointer(long address) {
        return address != 0L ? new ConvexMeshSupport(address) : null;
    }
    
    public static ConvexMeshSupport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected ConvexMeshSupport(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address    Pre-allocated memory, where the object is created.
     * @param convexMesh WebIDL type: {@link PxConvexMesh} [Const, Ref]
     * @return Stack allocated object of ConvexMeshSupport
     */
    public static ConvexMeshSupport createAt(long address, PxConvexMesh convexMesh) {
        __placement_new_ConvexMeshSupport(address, convexMesh.getAddress());
        ConvexMeshSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>        Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator  Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate   Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param convexMesh WebIDL type: {@link PxConvexMesh} [Const, Ref]
     * @return Stack allocated object of ConvexMeshSupport
     */
    public static <T> ConvexMeshSupport createAt(T allocator, Allocator<T> allocate, PxConvexMesh convexMesh) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_ConvexMeshSupport(address, convexMesh.getAddress());
        ConvexMeshSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_ConvexMeshSupport(long address, long convexMesh);

    /**
     * @param address    Pre-allocated memory, where the object is created.
     * @param convexMesh WebIDL type: {@link PxConvexMesh} [Const, Ref]
     * @param scale      WebIDL type: {@link PxVec3} [Const, Ref]
     * @return Stack allocated object of ConvexMeshSupport
     */
    public static ConvexMeshSupport createAt(long address, PxConvexMesh convexMesh, PxVec3 scale) {
        __placement_new_ConvexMeshSupport(address, convexMesh.getAddress(), scale.getAddress());
        ConvexMeshSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>        Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator  Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate   Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param convexMesh WebIDL type: {@link PxConvexMesh} [Const, Ref]
     * @param scale      WebIDL type: {@link PxVec3} [Const, Ref]
     * @return Stack allocated object of ConvexMeshSupport
     */
    public static <T> ConvexMeshSupport createAt(T allocator, Allocator<T> allocate, PxConvexMesh convexMesh, PxVec3 scale) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_ConvexMeshSupport(address, convexMesh.getAddress(), scale.getAddress());
        ConvexMeshSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_ConvexMeshSupport(long address, long convexMesh, long scale);

    /**
     * @param address       Pre-allocated memory, where the object is created.
     * @param convexMesh    WebIDL type: {@link PxConvexMesh} [Const, Ref]
     * @param scale         WebIDL type: {@link PxVec3} [Const, Ref]
     * @param scaleRotation WebIDL type: {@link PxQuat} [Const, Ref]
     * @return Stack allocated object of ConvexMeshSupport
     */
    public static ConvexMeshSupport createAt(long address, PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation) {
        __placement_new_ConvexMeshSupport(address, convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress());
        ConvexMeshSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>           Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator     Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate      Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param convexMesh    WebIDL type: {@link PxConvexMesh} [Const, Ref]
     * @param scale         WebIDL type: {@link PxVec3} [Const, Ref]
     * @param scaleRotation WebIDL type: {@link PxQuat} [Const, Ref]
     * @return Stack allocated object of ConvexMeshSupport
     */
    public static <T> ConvexMeshSupport createAt(T allocator, Allocator<T> allocate, PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_ConvexMeshSupport(address, convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress());
        ConvexMeshSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_ConvexMeshSupport(long address, long convexMesh, long scale, long scaleRotation);

    /**
     * @param address       Pre-allocated memory, where the object is created.
     * @param convexMesh    WebIDL type: {@link PxConvexMesh} [Const, Ref]
     * @param scale         WebIDL type: {@link PxVec3} [Const, Ref]
     * @param scaleRotation WebIDL type: {@link PxQuat} [Const, Ref]
     * @param margin        WebIDL type: float
     * @return Stack allocated object of ConvexMeshSupport
     */
    public static ConvexMeshSupport createAt(long address, PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation, float margin) {
        __placement_new_ConvexMeshSupport(address, convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress(), margin);
        ConvexMeshSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>           Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator     Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate      Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param convexMesh    WebIDL type: {@link PxConvexMesh} [Const, Ref]
     * @param scale         WebIDL type: {@link PxVec3} [Const, Ref]
     * @param scaleRotation WebIDL type: {@link PxQuat} [Const, Ref]
     * @param margin        WebIDL type: float
     * @return Stack allocated object of ConvexMeshSupport
     */
    public static <T> ConvexMeshSupport createAt(T allocator, Allocator<T> allocate, PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation, float margin) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_ConvexMeshSupport(address, convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress(), margin);
        ConvexMeshSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_ConvexMeshSupport(long address, long convexMesh, long scale, long scaleRotation, float margin);

    // Constructors

    /**
     * @param convexMesh WebIDL type: {@link PxConvexMesh} [Const, Ref]
     */
    public ConvexMeshSupport(PxConvexMesh convexMesh) {
        address = _ConvexMeshSupport(convexMesh.getAddress());
    }
    private static native long _ConvexMeshSupport(long convexMesh);

    /**
     * @param convexMesh WebIDL type: {@link PxConvexMesh} [Const, Ref]
     * @param scale      WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public ConvexMeshSupport(PxConvexMesh convexMesh, PxVec3 scale) {
        address = _ConvexMeshSupport(convexMesh.getAddress(), scale.getAddress());
    }
    private static native long _ConvexMeshSupport(long convexMesh, long scale);

    /**
     * @param convexMesh    WebIDL type: {@link PxConvexMesh} [Const, Ref]
     * @param scale         WebIDL type: {@link PxVec3} [Const, Ref]
     * @param scaleRotation WebIDL type: {@link PxQuat} [Const, Ref]
     */
    public ConvexMeshSupport(PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation) {
        address = _ConvexMeshSupport(convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress());
    }
    private static native long _ConvexMeshSupport(long convexMesh, long scale, long scaleRotation);

    /**
     * @param convexMesh    WebIDL type: {@link PxConvexMesh} [Const, Ref]
     * @param scale         WebIDL type: {@link PxVec3} [Const, Ref]
     * @param scaleRotation WebIDL type: {@link PxQuat} [Const, Ref]
     * @param margin        WebIDL type: float
     */
    public ConvexMeshSupport(PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation, float margin) {
        address = _ConvexMeshSupport(convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress(), margin);
    }
    private static native long _ConvexMeshSupport(long convexMesh, long scale, long scaleRotation, float margin);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxConvexMesh} [Platforms=windows;linux;macos]
     */
    public PxConvexMesh getConvexMesh() {
        checkNotNull();
        PlatformChecks.requirePlatform(7, "physx.extensions.ConvexMeshSupport");
        return PxConvexMesh.wrapPointer(_getConvexMesh(address));
    }
    private static native long _getConvexMesh(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getScale() {
        checkNotNull();
        return PxVec3.wrapPointer(_getScale(address));
    }
    private static native long _getScale(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setScale(PxVec3 value) {
        checkNotNull();
        _setScale(address, value.getAddress());
    }
    private static native void _setScale(long address, long value);

    /**
     * @return WebIDL type: {@link PxQuat} [Value]
     */
    public PxQuat getScaleRotation() {
        checkNotNull();
        return PxQuat.wrapPointer(_getScaleRotation(address));
    }
    private static native long _getScaleRotation(long address);

    /**
     * @param value WebIDL type: {@link PxQuat} [Value]
     */
    public void setScaleRotation(PxQuat value) {
        checkNotNull();
        _setScaleRotation(address, value.getAddress());
    }
    private static native void _setScaleRotation(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getMargin() {
        checkNotNull();
        return _getMargin(address);
    }
    private static native float _getMargin(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMargin(float value) {
        checkNotNull();
        _setMargin(address, value);
    }
    private static native void _setMargin(long address, float value);

}
