package physx.extensions;

import physx.NativeObject;
import physx.common.PxCollection;
import physx.physics.PxScene;

public class PxCollectionExt extends NativeObject {

    protected PxCollectionExt() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCollectionExt wrapPointer(long address) {
        return address != 0L ? new PxCollectionExt(address) : null;
    }
    
    public static PxCollectionExt arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCollectionExt(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param collection WebIDL type: {@link PxCollection} [Ref]
     */
    public static void releaseObjects(PxCollection collection) {
        _releaseObjects(collection.getAddress());
    }
    private static native void _releaseObjects(long collection);

    /**
     * @param collection             WebIDL type: {@link PxCollection} [Ref]
     * @param releaseExclusiveShapes WebIDL type: boolean
     */
    public static void releaseObjects(PxCollection collection, boolean releaseExclusiveShapes) {
        _releaseObjects(collection.getAddress(), releaseExclusiveShapes);
    }
    private static native void _releaseObjects(long collection, boolean releaseExclusiveShapes);

    /**
     * @param collection   WebIDL type: {@link PxCollection} [Ref]
     * @param concreteType WebIDL type: unsigned short
     */
    public static void remove(PxCollection collection, short concreteType) {
        _remove(collection.getAddress(), concreteType);
    }
    private static native void _remove(long collection, short concreteType);

    /**
     * @param collection   WebIDL type: {@link PxCollection} [Ref]
     * @param concreteType WebIDL type: unsigned short
     * @param to           WebIDL type: {@link PxCollection}
     */
    public static void remove(PxCollection collection, short concreteType, PxCollection to) {
        _remove(collection.getAddress(), concreteType, to.getAddress());
    }
    private static native void _remove(long collection, short concreteType, long to);

    /**
     * @param scene WebIDL type: {@link PxScene} [Ref]
     * @return WebIDL type: {@link PxCollection}
     */
    public static PxCollection createCollection(PxScene scene) {
        return PxCollection.wrapPointer(_createCollection(scene.getAddress()));
    }
    private static native long _createCollection(long scene);

}
