package physx.extensions;


public class PxD6JointDrive extends PxSpring {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxD6JointDrive wrapPointer(long address) {
        return address != 0L ? new PxD6JointDrive(address) : null;
    }
    
    public static PxD6JointDrive arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxD6JointDrive(long address) {
        super(address);
    }

    // Constructors

    public PxD6JointDrive() {
        address = _PxD6JointDrive();
    }
    private static native long _PxD6JointDrive();

    /**
     * @param driveStiffness  WebIDL type: float
     * @param driveDamping    WebIDL type: float
     * @param driveForceLimit WebIDL type: float
     */
    public PxD6JointDrive(float driveStiffness, float driveDamping, float driveForceLimit) {
        address = _PxD6JointDrive(driveStiffness, driveDamping, driveForceLimit);
    }
    private static native long _PxD6JointDrive(float driveStiffness, float driveDamping, float driveForceLimit);

    /**
     * @param driveStiffness  WebIDL type: float
     * @param driveDamping    WebIDL type: float
     * @param driveForceLimit WebIDL type: float
     * @param isAcceleration  WebIDL type: boolean
     */
    public PxD6JointDrive(float driveStiffness, float driveDamping, float driveForceLimit, boolean isAcceleration) {
        address = _PxD6JointDrive(driveStiffness, driveDamping, driveForceLimit, isAcceleration);
    }
    private static native long _PxD6JointDrive(float driveStiffness, float driveDamping, float driveForceLimit, boolean isAcceleration);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getForceLimit() {
        checkNotNull();
        return _getForceLimit(address);
    }
    private static native float _getForceLimit(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setForceLimit(float value) {
        checkNotNull();
        _setForceLimit(address, value);
    }
    private static native void _setForceLimit(long address, float value);

    /**
     * @return WebIDL type: {@link PxD6JointDriveFlags} [Value]
     */
    public PxD6JointDriveFlags getFlags() {
        checkNotNull();
        return PxD6JointDriveFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxD6JointDriveFlags} [Value]
     */
    public void setFlags(PxD6JointDriveFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

}
