package physx.extensions;


public class PxDistanceJoint extends PxJoint {

    protected PxDistanceJoint() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxDistanceJoint wrapPointer(long address) {
        return address != 0L ? new PxDistanceJoint(address) : null;
    }
    
    public static PxDistanceJoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxDistanceJoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: float
     */
    public float getDistance() {
        checkNotNull();
        return _getDistance(address);
    }
    private static native float _getDistance(long address);

    /**
     * @param distance WebIDL type: float
     */
    public void setMinDistance(float distance) {
        checkNotNull();
        _setMinDistance(address, distance);
    }
    private static native void _setMinDistance(long address, float distance);

    /**
     * @return WebIDL type: float
     */
    public float getMinDistance() {
        checkNotNull();
        return _getMinDistance(address);
    }
    private static native float _getMinDistance(long address);

    /**
     * @param distance WebIDL type: float
     */
    public void setMaxDistance(float distance) {
        checkNotNull();
        _setMaxDistance(address, distance);
    }
    private static native void _setMaxDistance(long address, float distance);

    /**
     * @return WebIDL type: float
     */
    public float getMaxDistance() {
        checkNotNull();
        return _getMaxDistance(address);
    }
    private static native float _getMaxDistance(long address);

    /**
     * @param tolerance WebIDL type: float
     */
    public void setTolerance(float tolerance) {
        checkNotNull();
        _setTolerance(address, tolerance);
    }
    private static native void _setTolerance(long address, float tolerance);

    /**
     * @return WebIDL type: float
     */
    public float getTolerance() {
        checkNotNull();
        return _getTolerance(address);
    }
    private static native float _getTolerance(long address);

    /**
     * @param stiffness WebIDL type: float
     */
    public void setStiffness(float stiffness) {
        checkNotNull();
        _setStiffness(address, stiffness);
    }
    private static native void _setStiffness(long address, float stiffness);

    /**
     * @return WebIDL type: float
     */
    public float getStiffness() {
        checkNotNull();
        return _getStiffness(address);
    }
    private static native float _getStiffness(long address);

    /**
     * @param damping WebIDL type: float
     */
    public void setDamping(float damping) {
        checkNotNull();
        _setDamping(address, damping);
    }
    private static native void _setDamping(long address, float damping);

    /**
     * @return WebIDL type: float
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * @param flags WebIDL type: {@link PxDistanceJointFlags} [Ref]
     */
    public void setDistanceJointFlags(PxDistanceJointFlags flags) {
        checkNotNull();
        _setDistanceJointFlags(address, flags.getAddress());
    }
    private static native void _setDistanceJointFlags(long address, long flags);

    /**
     * @param flag  WebIDL type: {@link PxDistanceJointFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setDistanceJointFlag(PxDistanceJointFlagEnum flag, boolean value) {
        checkNotNull();
        _setDistanceJointFlag(address, flag.value, value);
    }
    private static native void _setDistanceJointFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxDistanceJointFlags} [Value]
     */
    public PxDistanceJointFlags getDistanceJointFlags() {
        checkNotNull();
        return PxDistanceJointFlags.wrapPointer(_getDistanceJointFlags(address));
    }
    private static native long _getDistanceJointFlags(long address);

}
