package physx.extensions;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;

public class PxGjkQuery extends NativeObject {

    protected PxGjkQuery() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxGjkQuery wrapPointer(long address) {
        return address != 0L ? new PxGjkQuery(address) : null;
    }
    
    public static PxGjkQuery arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxGjkQuery(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param a               WebIDL type: {@link Support} [Const, Ref]
     * @param b               WebIDL type: {@link Support} [Const, Ref]
     * @param poseA           WebIDL type: {@link PxTransform} [Const, Ref]
     * @param poseB           WebIDL type: {@link PxTransform} [Const, Ref]
     * @param contactDistance WebIDL type: float
     * @param toleranceLength WebIDL type: float
     * @param result          WebIDL type: {@link PxGjkQueryProximityInfoResult} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean proximityInfo(Support a, Support b, PxTransform poseA, PxTransform poseB, float contactDistance, float toleranceLength, PxGjkQueryProximityInfoResult result) {
        return _proximityInfo(a.getAddress(), b.getAddress(), poseA.getAddress(), poseB.getAddress(), contactDistance, toleranceLength, result.getAddress());
    }
    private static native boolean _proximityInfo(long a, long b, long poseA, long poseB, float contactDistance, float toleranceLength, long result);

    /**
     * @param shape    WebIDL type: {@link Support} [Const, Ref]
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param rayStart WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param maxDist  WebIDL type: float
     * @param result   WebIDL type: {@link PxGjkQueryRaycastResult} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean raycast(Support shape, PxTransform pose, PxVec3 rayStart, PxVec3 unitDir, float maxDist, PxGjkQueryRaycastResult result) {
        return _raycast(shape.getAddress(), pose.getAddress(), rayStart.getAddress(), unitDir.getAddress(), maxDist, result.getAddress());
    }
    private static native boolean _raycast(long shape, long pose, long rayStart, long unitDir, float maxDist, long result);

    /**
     * @param a     WebIDL type: {@link Support} [Const, Ref]
     * @param b     WebIDL type: {@link Support} [Const, Ref]
     * @param poseA WebIDL type: {@link PxTransform} [Const, Ref]
     * @param poseB WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public static boolean overlap(Support a, Support b, PxTransform poseA, PxTransform poseB) {
        return _overlap(a.getAddress(), b.getAddress(), poseA.getAddress(), poseB.getAddress());
    }
    private static native boolean _overlap(long a, long b, long poseA, long poseB);

    /**
     * @param a       WebIDL type: {@link Support} [Const, Ref]
     * @param b       WebIDL type: {@link Support} [Const, Ref]
     * @param poseA   WebIDL type: {@link PxTransform} [Const, Ref]
     * @param poseB   WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir WebIDL type: {@link PxVec3} [Const, Ref]
     * @param maxDist WebIDL type: float
     * @param result  WebIDL type: {@link PxGjkQuerySweepResult} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean sweep(Support a, Support b, PxTransform poseA, PxTransform poseB, PxVec3 unitDir, float maxDist, PxGjkQuerySweepResult result) {
        return _sweep(a.getAddress(), b.getAddress(), poseA.getAddress(), poseB.getAddress(), unitDir.getAddress(), maxDist, result.getAddress());
    }
    private static native boolean _sweep(long a, long b, long poseA, long poseB, long unitDir, float maxDist, long result);

}
