package physx.extensions;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.geometry.PxContactBuffer;

public class PxGjkQueryExt extends NativeObject {

    protected PxGjkQueryExt() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxGjkQueryExt wrapPointer(long address) {
        return address != 0L ? new PxGjkQueryExt(address) : null;
    }
    
    public static PxGjkQueryExt arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxGjkQueryExt(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param a               WebIDL type: {@link Support} [Const, Ref]
     * @param b               WebIDL type: {@link Support} [Const, Ref]
     * @param poseA           WebIDL type: {@link PxTransform} [Const, Ref]
     * @param poseB           WebIDL type: {@link PxTransform} [Const, Ref]
     * @param contactDistance WebIDL type: float
     * @param toleranceLength WebIDL type: float
     * @param contactBuffer   WebIDL type: {@link PxContactBuffer} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean generateContacts(Support a, Support b, PxTransform poseA, PxTransform poseB, float contactDistance, float toleranceLength, PxContactBuffer contactBuffer) {
        return _generateContacts(a.getAddress(), b.getAddress(), poseA.getAddress(), poseB.getAddress(), contactDistance, toleranceLength, contactBuffer.getAddress());
    }
    private static native boolean _generateContacts(long a, long b, long poseA, long poseB, float contactDistance, float toleranceLength, long contactBuffer);

}
