package physx.extensions;

import physx.NativeObject;
import physx.common.PxBase;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxConstraint;
import physx.physics.PxConstraintFlagEnum;
import physx.physics.PxConstraintFlags;
import physx.physics.PxRigidActor;
import physx.physics.PxScene;

public class PxJoint extends PxBase {

    protected PxJoint() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxJoint wrapPointer(long address) {
        return address != 0L ? new PxJoint(address) : null;
    }
    
    public static PxJoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxJoint(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    // Functions

    /**
     * @param actor0 WebIDL type: {@link PxRigidActor}
     * @param actor1 WebIDL type: {@link PxRigidActor}
     */
    public void setActors(PxRigidActor actor0, PxRigidActor actor1) {
        checkNotNull();
        _setActors(address, actor0.getAddress(), actor1.getAddress());
    }
    private static native void _setActors(long address, long actor0, long actor1);

    /**
     * @param actor     WebIDL type: {@link PxJointActorIndexEnum} [enum]
     * @param localPose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setLocalPose(PxJointActorIndexEnum actor, PxTransform localPose) {
        checkNotNull();
        _setLocalPose(address, actor.value, localPose.getAddress());
    }
    private static native void _setLocalPose(long address, int actor, long localPose);

    /**
     * @param actor WebIDL type: {@link PxJointActorIndexEnum} [enum]
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getLocalPose(PxJointActorIndexEnum actor) {
        checkNotNull();
        return PxTransform.wrapPointer(_getLocalPose(address, actor.value));
    }
    private static native long _getLocalPose(long address, int actor);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getRelativeTransform() {
        checkNotNull();
        return PxTransform.wrapPointer(_getRelativeTransform(address));
    }
    private static native long _getRelativeTransform(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getRelativeLinearVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getRelativeLinearVelocity(address));
    }
    private static native long _getRelativeLinearVelocity(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getRelativeAngularVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getRelativeAngularVelocity(address));
    }
    private static native long _getRelativeAngularVelocity(long address);

    /**
     * @param force  WebIDL type: float
     * @param torque WebIDL type: float
     */
    public void setBreakForce(float force, float torque) {
        checkNotNull();
        _setBreakForce(address, force, torque);
    }
    private static native void _setBreakForce(long address, float force, float torque);

    /**
     * @param flags WebIDL type: {@link PxConstraintFlags} [Ref]
     */
    public void setConstraintFlags(PxConstraintFlags flags) {
        checkNotNull();
        _setConstraintFlags(address, flags.getAddress());
    }
    private static native void _setConstraintFlags(long address, long flags);

    /**
     * @param flag  WebIDL type: {@link PxConstraintFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setConstraintFlag(PxConstraintFlagEnum flag, boolean value) {
        checkNotNull();
        _setConstraintFlag(address, flag.value, value);
    }
    private static native void _setConstraintFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxConstraintFlags} [Value]
     */
    public PxConstraintFlags getConstraintFlags() {
        checkNotNull();
        return PxConstraintFlags.wrapPointer(_getConstraintFlags(address));
    }
    private static native long _getConstraintFlags(long address);

    /**
     * @param invMassScale WebIDL type: float
     */
    public void setInvMassScale0(float invMassScale) {
        checkNotNull();
        _setInvMassScale0(address, invMassScale);
    }
    private static native void _setInvMassScale0(long address, float invMassScale);

    /**
     * @return WebIDL type: float
     */
    public float getInvMassScale0() {
        checkNotNull();
        return _getInvMassScale0(address);
    }
    private static native float _getInvMassScale0(long address);

    /**
     * @param invMassScale WebIDL type: float
     */
    public void setInvMassScale1(float invMassScale) {
        checkNotNull();
        _setInvMassScale1(address, invMassScale);
    }
    private static native void _setInvMassScale1(long address, float invMassScale);

    /**
     * @return WebIDL type: float
     */
    public float getInvMassScale1() {
        checkNotNull();
        return _getInvMassScale1(address);
    }
    private static native float _getInvMassScale1(long address);

    /**
     * @return WebIDL type: {@link PxConstraint}
     */
    public PxConstraint getConstraint() {
        checkNotNull();
        return PxConstraint.wrapPointer(_getConstraint(address));
    }
    private static native long _getConstraint(long address);

    /**
     * @param name WebIDL type: DOMString [Const]
     */
    public void setName(String name) {
        checkNotNull();
        _setName(address, name);
    }
    private static native void _setName(long address, String name);

    /**
     * @return WebIDL type: DOMString [Const]
     */
    public String getName() {
        checkNotNull();
        return _getName(address);
    }
    private static native String _getName(long address);

    /**
     * @return WebIDL type: {@link PxScene}
     */
    public PxScene getScene() {
        checkNotNull();
        return PxScene.wrapPointer(_getScene(address));
    }
    private static native long _getScene(long address);

}
