package physx.extensions;


public class PxJointLimitCone extends PxJointLimitParameters {

    protected PxJointLimitCone() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxJointLimitCone wrapPointer(long address) {
        return address != 0L ? new PxJointLimitCone(address) : null;
    }
    
    public static PxJointLimitCone arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxJointLimitCone(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param yLimitAngle WebIDL type: float
     * @param zLimitAngle WebIDL type: float
     * @param spring      WebIDL type: {@link PxSpring} [Const, Ref]
     */
    public PxJointLimitCone(float yLimitAngle, float zLimitAngle, PxSpring spring) {
        address = _PxJointLimitCone(yLimitAngle, zLimitAngle, spring.getAddress());
    }
    private static native long _PxJointLimitCone(float yLimitAngle, float zLimitAngle, long spring);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getYAngle() {
        checkNotNull();
        return _getYAngle(address);
    }
    private static native float _getYAngle(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setYAngle(float value) {
        checkNotNull();
        _setYAngle(address, value);
    }
    private static native void _setYAngle(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getZAngle() {
        checkNotNull();
        return _getZAngle(address);
    }
    private static native float _getZAngle(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setZAngle(float value) {
        checkNotNull();
        _setZAngle(address, value);
    }
    private static native void _setZAngle(long address, float value);

}
