package physx.extensions;

import physx.NativeObject;

public class PxJointLimitParameters extends NativeObject {

    protected PxJointLimitParameters() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxJointLimitParameters wrapPointer(long address) {
        return address != 0L ? new PxJointLimitParameters(address) : null;
    }
    
    public static PxJointLimitParameters arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxJointLimitParameters(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getRestitution() {
        checkNotNull();
        return _getRestitution(address);
    }
    private static native float _getRestitution(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRestitution(float value) {
        checkNotNull();
        _setRestitution(address, value);
    }
    private static native void _setRestitution(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getBounceThreshold() {
        checkNotNull();
        return _getBounceThreshold(address);
    }
    private static native float _getBounceThreshold(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setBounceThreshold(float value) {
        checkNotNull();
        _setBounceThreshold(address, value);
    }
    private static native void _setBounceThreshold(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getStiffness() {
        checkNotNull();
        return _getStiffness(address);
    }
    private static native float _getStiffness(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setStiffness(float value) {
        checkNotNull();
        _setStiffness(address, value);
    }
    private static native void _setStiffness(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDamping(float value) {
        checkNotNull();
        _setDamping(address, value);
    }
    private static native void _setDamping(long address, float value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isSoft() {
        checkNotNull();
        return _isSoft(address);
    }
    private static native boolean _isSoft(long address);

}
