package physx.extensions;


public class PxJointLinearLimit extends PxJointLimitParameters {

    protected PxJointLinearLimit() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxJointLinearLimit wrapPointer(long address) {
        return address != 0L ? new PxJointLinearLimit(address) : null;
    }
    
    public static PxJointLinearLimit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxJointLinearLimit(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param extent WebIDL type: float
     * @param spring WebIDL type: {@link PxSpring} [Const, Ref]
     */
    public PxJointLinearLimit(float extent, PxSpring spring) {
        address = _PxJointLinearLimit(extent, spring.getAddress());
    }
    private static native long _PxJointLinearLimit(float extent, long spring);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getValue() {
        checkNotNull();
        return _getValue(address);
    }
    private static native float _getValue(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setValue(float value) {
        checkNotNull();
        _setValue(address, value);
    }
    private static native void _setValue(long address, float value);

}
