package physx.extensions;

import physx.NativeObject;
import physx.common.PxMat33;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.geometry.PxGeometry;

public class PxMassProperties extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxMassProperties wrapPointer(long address) {
        return address != 0L ? new PxMassProperties(address) : null;
    }
    
    public static PxMassProperties arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxMassProperties(long address) {
        super(address);
    }

    // Constructors

    public PxMassProperties() {
        address = _PxMassProperties();
    }
    private static native long _PxMassProperties();

    /**
     * @param m        WebIDL type: float
     * @param inertiaT WebIDL type: {@link PxMat33} [Const, Ref]
     * @param com      WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public PxMassProperties(float m, PxMat33 inertiaT, PxVec3 com) {
        address = _PxMassProperties(m, inertiaT.getAddress(), com.getAddress());
    }
    private static native long _PxMassProperties(float m, long inertiaT, long com);

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     */
    public PxMassProperties(PxGeometry geometry) {
        address = _PxMassProperties(geometry.getAddress());
    }
    private static native long _PxMassProperties(long geometry);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxMat33} [Value]
     */
    public PxMat33 getInertiaTensor() {
        checkNotNull();
        return PxMat33.wrapPointer(_getInertiaTensor(address));
    }
    private static native long _getInertiaTensor(long address);

    /**
     * @param value WebIDL type: {@link PxMat33} [Value]
     */
    public void setInertiaTensor(PxMat33 value) {
        checkNotNull();
        _setInertiaTensor(address, value.getAddress());
    }
    private static native void _setInertiaTensor(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getCenterOfMass() {
        checkNotNull();
        return PxVec3.wrapPointer(_getCenterOfMass(address));
    }
    private static native long _getCenterOfMass(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setCenterOfMass(PxVec3 value) {
        checkNotNull();
        _setCenterOfMass(address, value.getAddress());
    }
    private static native void _setCenterOfMass(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getMass() {
        checkNotNull();
        return _getMass(address);
    }
    private static native float _getMass(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMass(float value) {
        checkNotNull();
        _setMass(address, value);
    }
    private static native void _setMass(long address, float value);

    // Functions

    /**
     * @param t WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void translate(PxVec3 t) {
        checkNotNull();
        _translate(address, t.getAddress());
    }
    private static native void _translate(long address, long t);

    /**
     * @param inertia   WebIDL type: {@link PxMat33} [Const, Ref]
     * @param massFrame WebIDL type: {@link PxQuat} [Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public static PxVec3 getMassSpaceInertia(PxMat33 inertia, PxQuat massFrame) {
        return PxVec3.wrapPointer(_getMassSpaceInertia(inertia.getAddress(), massFrame.getAddress()));
    }
    private static native long _getMassSpaceInertia(long inertia, long massFrame);

    /**
     * @param inertia WebIDL type: {@link PxMat33} [Const, Ref]
     * @param mass    WebIDL type: float
     * @param t       WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxMat33} [Value]
     */
    public static PxMat33 translateInertia(PxMat33 inertia, float mass, PxVec3 t) {
        return PxMat33.wrapPointer(_translateInertia(inertia.getAddress(), mass, t.getAddress()));
    }
    private static native long _translateInertia(long inertia, float mass, long t);

    /**
     * @param inertia WebIDL type: {@link PxMat33} [Const, Ref]
     * @param q       WebIDL type: {@link PxQuat} [Const, Ref]
     * @return WebIDL type: {@link PxMat33} [Value]
     */
    public static PxMat33 rotateInertia(PxMat33 inertia, PxQuat q) {
        return PxMat33.wrapPointer(_rotateInertia(inertia.getAddress(), q.getAddress()));
    }
    private static native long _rotateInertia(long inertia, long q);

    /**
     * @param inertia       WebIDL type: {@link PxMat33} [Const, Ref]
     * @param scaleRotation WebIDL type: {@link PxQuat} [Const, Ref]
     * @param scale         WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxMat33} [Value]
     */
    public static PxMat33 scaleInertia(PxMat33 inertia, PxQuat scaleRotation, PxVec3 scale) {
        return PxMat33.wrapPointer(_scaleInertia(inertia.getAddress(), scaleRotation.getAddress(), scale.getAddress()));
    }
    private static native long _scaleInertia(long inertia, long scaleRotation, long scale);

    /**
     * @param props      WebIDL type: {@link PxMassProperties} [Const]
     * @param transforms WebIDL type: {@link PxTransform} [Const]
     * @param count      WebIDL type: unsigned long
     * @return WebIDL type: {@link PxMassProperties} [Value]
     */
    public static PxMassProperties sum(PxMassProperties props, PxTransform transforms, int count) {
        return PxMassProperties.wrapPointer(_sum(props.getAddress(), transforms.getAddress(), count));
    }
    private static native long _sum(long props, long transforms, int count);

}
