package physx.extensions;


public class PxPrismaticJoint extends PxJoint {

    protected PxPrismaticJoint() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxPrismaticJoint wrapPointer(long address) {
        return address != 0L ? new PxPrismaticJoint(address) : null;
    }
    
    public static PxPrismaticJoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxPrismaticJoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: float
     */
    public float getPosition() {
        checkNotNull();
        return _getPosition(address);
    }
    private static native float _getPosition(long address);

    /**
     * @return WebIDL type: float
     */
    public float getVelocity() {
        checkNotNull();
        return _getVelocity(address);
    }
    private static native float _getVelocity(long address);

    /**
     * @param limit WebIDL type: {@link PxJointLinearLimitPair} [Const, Ref]
     */
    public void setLimit(PxJointLinearLimitPair limit) {
        checkNotNull();
        _setLimit(address, limit.getAddress());
    }
    private static native void _setLimit(long address, long limit);

    /**
     * @param flags WebIDL type: {@link PxPrismaticJointFlags} [Ref]
     */
    public void setPrismaticJointFlags(PxPrismaticJointFlags flags) {
        checkNotNull();
        _setPrismaticJointFlags(address, flags.getAddress());
    }
    private static native void _setPrismaticJointFlags(long address, long flags);

    /**
     * @param flag  WebIDL type: {@link PxPrismaticJointFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setPrismaticJointFlag(PxPrismaticJointFlagEnum flag, boolean value) {
        checkNotNull();
        _setPrismaticJointFlag(address, flag.value, value);
    }
    private static native void _setPrismaticJointFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxPrismaticJointFlags} [Value]
     */
    public PxPrismaticJointFlags getPrismaticJointFlags() {
        checkNotNull();
        return PxPrismaticJointFlags.wrapPointer(_getPrismaticJointFlags(address));
    }
    private static native long _getPrismaticJointFlags(long address);

}
