package physx.extensions;


public class PxRevoluteJoint extends PxJoint {

    protected PxRevoluteJoint() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxRevoluteJoint wrapPointer(long address) {
        return address != 0L ? new PxRevoluteJoint(address) : null;
    }
    
    public static PxRevoluteJoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxRevoluteJoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: float
     */
    public float getAngle() {
        checkNotNull();
        return _getAngle(address);
    }
    private static native float _getAngle(long address);

    /**
     * @return WebIDL type: float
     */
    public float getVelocity() {
        checkNotNull();
        return _getVelocity(address);
    }
    private static native float _getVelocity(long address);

    /**
     * @param limits WebIDL type: {@link PxJointAngularLimitPair} [Const, Ref]
     */
    public void setLimit(PxJointAngularLimitPair limits) {
        checkNotNull();
        _setLimit(address, limits.getAddress());
    }
    private static native void _setLimit(long address, long limits);

    /**
     * @param velocity WebIDL type: float
     */
    public void setDriveVelocity(float velocity) {
        checkNotNull();
        _setDriveVelocity(address, velocity);
    }
    private static native void _setDriveVelocity(long address, float velocity);

    /**
     * @param velocity WebIDL type: float
     * @param autowake WebIDL type: boolean
     */
    public void setDriveVelocity(float velocity, boolean autowake) {
        checkNotNull();
        _setDriveVelocity(address, velocity, autowake);
    }
    private static native void _setDriveVelocity(long address, float velocity, boolean autowake);

    /**
     * @return WebIDL type: float
     */
    public float getDriveVelocity() {
        checkNotNull();
        return _getDriveVelocity(address);
    }
    private static native float _getDriveVelocity(long address);

    /**
     * @param limit WebIDL type: float
     */
    public void setDriveForceLimit(float limit) {
        checkNotNull();
        _setDriveForceLimit(address, limit);
    }
    private static native void _setDriveForceLimit(long address, float limit);

    /**
     * @return WebIDL type: float
     */
    public float getDriveForceLimit() {
        checkNotNull();
        return _getDriveForceLimit(address);
    }
    private static native float _getDriveForceLimit(long address);

    /**
     * @param ratio WebIDL type: float
     */
    public void setDriveGearRatio(float ratio) {
        checkNotNull();
        _setDriveGearRatio(address, ratio);
    }
    private static native void _setDriveGearRatio(long address, float ratio);

    /**
     * @return WebIDL type: float
     */
    public float getDriveGearRatio() {
        checkNotNull();
        return _getDriveGearRatio(address);
    }
    private static native float _getDriveGearRatio(long address);

    /**
     * @param flags WebIDL type: {@link PxRevoluteJointFlags} [Ref]
     */
    public void setRevoluteJointFlags(PxRevoluteJointFlags flags) {
        checkNotNull();
        _setRevoluteJointFlags(address, flags.getAddress());
    }
    private static native void _setRevoluteJointFlags(long address, long flags);

    /**
     * @param flag  WebIDL type: {@link PxRevoluteJointFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setRevoluteJointFlag(PxRevoluteJointFlagEnum flag, boolean value) {
        checkNotNull();
        _setRevoluteJointFlag(address, flag.value, value);
    }
    private static native void _setRevoluteJointFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxRevoluteJointFlags} [Value]
     */
    public PxRevoluteJointFlags getRevoluteJointFlags() {
        checkNotNull();
        return PxRevoluteJointFlags.wrapPointer(_getRevoluteJointFlags(address));
    }
    private static native long _getRevoluteJointFlags(long address);

}
