package physx.extensions;

import physx.NativeObject;
import physx.geometry.PxGeometry;
import physx.physics.PxMaterial;
import physx.physics.PxRigidActor;
import physx.physics.PxShape;
import physx.physics.PxShapeFlags;

public class PxRigidActorExt extends NativeObject {

    protected PxRigidActorExt() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxRigidActorExt wrapPointer(long address) {
        return address != 0L ? new PxRigidActorExt(address) : null;
    }
    
    public static PxRigidActorExt arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxRigidActorExt(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param actor    WebIDL type: {@link PxRigidActor} [Ref]
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param material WebIDL type: {@link PxMaterial} [Const, Ref]
     * @return WebIDL type: {@link PxShape}
     */
    public static PxShape createExclusiveShape(PxRigidActor actor, PxGeometry geometry, PxMaterial material) {
        return PxShape.wrapPointer(_createExclusiveShape(actor.getAddress(), geometry.getAddress(), material.getAddress()));
    }
    private static native long _createExclusiveShape(long actor, long geometry, long material);

    /**
     * @param actor    WebIDL type: {@link PxRigidActor} [Ref]
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param material WebIDL type: {@link PxMaterial} [Const, Ref]
     * @param flags    WebIDL type: {@link PxShapeFlags} [Ref]
     * @return WebIDL type: {@link PxShape}
     */
    public static PxShape createExclusiveShape(PxRigidActor actor, PxGeometry geometry, PxMaterial material, PxShapeFlags flags) {
        return PxShape.wrapPointer(_createExclusiveShape(actor.getAddress(), geometry.getAddress(), material.getAddress(), flags.getAddress()));
    }
    private static native long _createExclusiveShape(long actor, long geometry, long material, long flags);

}
