package physx.extensions;


public class PxSphericalJoint extends PxJoint {

    protected PxSphericalJoint() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSphericalJoint wrapPointer(long address) {
        return address != 0L ? new PxSphericalJoint(address) : null;
    }
    
    public static PxSphericalJoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSphericalJoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param limitCone WebIDL type: {@link PxJointLimitCone} [Const, Ref]
     */
    public void setLimitCone(PxJointLimitCone limitCone) {
        checkNotNull();
        _setLimitCone(address, limitCone.getAddress());
    }
    private static native void _setLimitCone(long address, long limitCone);

    /**
     * @return WebIDL type: float
     */
    public float getSwingYAngle() {
        checkNotNull();
        return _getSwingYAngle(address);
    }
    private static native float _getSwingYAngle(long address);

    /**
     * @return WebIDL type: float
     */
    public float getSwingZAngle() {
        checkNotNull();
        return _getSwingZAngle(address);
    }
    private static native float _getSwingZAngle(long address);

    /**
     * @param flags WebIDL type: {@link PxSphericalJointFlags} [Ref]
     */
    public void setSphericalJointFlags(PxSphericalJointFlags flags) {
        checkNotNull();
        _setSphericalJointFlags(address, flags.getAddress());
    }
    private static native void _setSphericalJointFlags(long address, long flags);

    /**
     * @param flag  WebIDL type: {@link PxSphericalJointFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setSphericalJointFlag(PxSphericalJointFlagEnum flag, boolean value) {
        checkNotNull();
        _setSphericalJointFlag(address, flag.value, value);
    }
    private static native void _setSphericalJointFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxSphericalJointFlags} [Value]
     */
    public PxSphericalJointFlags getSphericalJointFlags() {
        checkNotNull();
        return PxSphericalJointFlags.wrapPointer(_getSphericalJointFlags(address));
    }
    private static native long _getSphericalJointFlags(long address);

}
