package physx.extensions;

import physx.NativeObject;
import physx.common.PxVec3;

public class Support extends NativeObject {

    protected Support() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static Support wrapPointer(long address) {
        return address != 0L ? new Support(address) : null;
    }
    
    public static Support arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected Support(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: float
     */
    public float getMargin() {
        checkNotNull();
        return _getMargin(address);
    }
    private static native float _getMargin(long address);

    /**
     * @param dir WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 supportLocal(PxVec3 dir) {
        checkNotNull();
        return PxVec3.wrapPointer(_supportLocal(address, dir.getAddress()));
    }
    private static native long _supportLocal(long address, long dir);

}
