package physx.geometry;


public class PxCapsuleGeometry extends PxGeometry {

    protected PxCapsuleGeometry() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCapsuleGeometry wrapPointer(long address) {
        return address != 0L ? new PxCapsuleGeometry(address) : null;
    }
    
    public static PxCapsuleGeometry arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCapsuleGeometry(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address    Pre-allocated memory, where the object is created.
     * @param radius     WebIDL type: float
     * @param halfHeight WebIDL type: float
     * @return Stack allocated object of PxCapsuleGeometry
     */
    public static PxCapsuleGeometry createAt(long address, float radius, float halfHeight) {
        __placement_new_PxCapsuleGeometry(address, radius, halfHeight);
        PxCapsuleGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>        Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator  Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate   Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param radius     WebIDL type: float
     * @param halfHeight WebIDL type: float
     * @return Stack allocated object of PxCapsuleGeometry
     */
    public static <T> PxCapsuleGeometry createAt(T allocator, Allocator<T> allocate, float radius, float halfHeight) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxCapsuleGeometry(address, radius, halfHeight);
        PxCapsuleGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxCapsuleGeometry(long address, float radius, float halfHeight);

    // Constructors

    /**
     * @param radius     WebIDL type: float
     * @param halfHeight WebIDL type: float
     */
    public PxCapsuleGeometry(float radius, float halfHeight) {
        address = _PxCapsuleGeometry(radius, halfHeight);
    }
    private static native long _PxCapsuleGeometry(float radius, float halfHeight);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getRadius() {
        checkNotNull();
        return _getRadius(address);
    }
    private static native float _getRadius(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRadius(float value) {
        checkNotNull();
        _setRadius(address, value);
    }
    private static native void _setRadius(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getHalfHeight() {
        checkNotNull();
        return _getHalfHeight(address);
    }
    private static native float _getHalfHeight(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setHalfHeight(float value) {
        checkNotNull();
        _setHalfHeight(address, value);
    }
    private static native void _setHalfHeight(long address, float value);

}
