package physx.geometry;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxContactPoint extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxContactPoint wrapPointer(long address) {
        return address != 0L ? new PxContactPoint(address) : null;
    }
    
    public static PxContactPoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxContactPoint(long address) {
        super(address);
    }

    // Constructors

    public PxContactPoint() {
        address = _PxContactPoint();
    }
    private static native long _PxContactPoint();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getNormal() {
        checkNotNull();
        return PxVec3.wrapPointer(_getNormal(address));
    }
    private static native long _getNormal(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setNormal(PxVec3 value) {
        checkNotNull();
        _setNormal(address, value.getAddress());
    }
    private static native void _setNormal(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getPoint() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPoint(address));
    }
    private static native long _getPoint(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setPoint(PxVec3 value) {
        checkNotNull();
        _setPoint(address, value.getAddress());
    }
    private static native void _setPoint(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTargetVel() {
        checkNotNull();
        return PxVec3.wrapPointer(_getTargetVel(address));
    }
    private static native long _getTargetVel(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTargetVel(PxVec3 value) {
        checkNotNull();
        _setTargetVel(address, value.getAddress());
    }
    private static native void _setTargetVel(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getSeparation() {
        checkNotNull();
        return _getSeparation(address);
    }
    private static native float _getSeparation(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setSeparation(float value) {
        checkNotNull();
        _setSeparation(address, value);
    }
    private static native void _setSeparation(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMaxImpulse() {
        checkNotNull();
        return _getMaxImpulse(address);
    }
    private static native float _getMaxImpulse(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMaxImpulse(float value) {
        checkNotNull();
        _setMaxImpulse(address, value);
    }
    private static native void _setMaxImpulse(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getStaticFriction() {
        checkNotNull();
        return _getStaticFriction(address);
    }
    private static native float _getStaticFriction(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setStaticFriction(float value) {
        checkNotNull();
        _setStaticFriction(address, value);
    }
    private static native void _setStaticFriction(long address, float value);

    /**
     * @return WebIDL type: octet
     */
    public byte getMaterialFlags() {
        checkNotNull();
        return _getMaterialFlags(address);
    }
    private static native byte _getMaterialFlags(long address);

    /**
     * @param value WebIDL type: octet
     */
    public void setMaterialFlags(byte value) {
        checkNotNull();
        _setMaterialFlags(address, value);
    }
    private static native void _setMaterialFlags(long address, byte value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getInternalFaceIndex1() {
        checkNotNull();
        return _getInternalFaceIndex1(address);
    }
    private static native int _getInternalFaceIndex1(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setInternalFaceIndex1(int value) {
        checkNotNull();
        _setInternalFaceIndex1(address, value);
    }
    private static native void _setInternalFaceIndex1(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getDynamicFriction() {
        checkNotNull();
        return _getDynamicFriction(address);
    }
    private static native float _getDynamicFriction(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDynamicFriction(float value) {
        checkNotNull();
        _setDynamicFriction(address, value);
    }
    private static native void _setDynamicFriction(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getRestitution() {
        checkNotNull();
        return _getRestitution(address);
    }
    private static native float _getRestitution(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRestitution(float value) {
        checkNotNull();
        _setRestitution(address, value);
    }
    private static native void _setRestitution(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDamping(float value) {
        checkNotNull();
        _setDamping(address, value);
    }
    private static native void _setDamping(long address, float value);

}
