package physx.geometry;

import physx.common.PxBounds3;
import physx.common.PxRefCounted;
import physx.common.PxVec3;
import physx.support.PxU8ConstPtr;

public class PxConvexMesh extends PxRefCounted {

    protected PxConvexMesh() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxConvexMesh wrapPointer(long address) {
        return address != 0L ? new PxConvexMesh(address) : null;
    }
    
    public static PxConvexMesh arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxConvexMesh(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbVertices() {
        checkNotNull();
        return _getNbVertices(address);
    }
    private static native int _getNbVertices(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Const]
     */
    public PxVec3 getVertices() {
        checkNotNull();
        return PxVec3.wrapPointer(_getVertices(address));
    }
    private static native long _getVertices(long address);

    /**
     * @return WebIDL type: {@link PxU8ConstPtr} [Value]
     */
    public PxU8ConstPtr getIndexBuffer() {
        checkNotNull();
        return PxU8ConstPtr.wrapPointer(_getIndexBuffer(address));
    }
    private static native long _getIndexBuffer(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbPolygons() {
        checkNotNull();
        return _getNbPolygons(address);
    }
    private static native int _getNbPolygons(long address);

    /**
     * @param index WebIDL type: unsigned long
     * @param data  WebIDL type: {@link PxHullPolygon} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean getPolygonData(int index, PxHullPolygon data) {
        checkNotNull();
        return _getPolygonData(address, index, data.getAddress());
    }
    private static native boolean _getPolygonData(long address, int index, long data);

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getLocalBounds() {
        checkNotNull();
        return PxBounds3.wrapPointer(_getLocalBounds(address));
    }
    private static native long _getLocalBounds(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isGpuCompatible() {
        checkNotNull();
        return _isGpuCompatible(address);
    }
    private static native boolean _isGpuCompatible(long address);

}
