package physx.geometry;


public class PxConvexMeshGeometry extends PxGeometry {

    protected PxConvexMeshGeometry() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxConvexMeshGeometry wrapPointer(long address) {
        return address != 0L ? new PxConvexMeshGeometry(address) : null;
    }
    
    public static PxConvexMeshGeometry arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxConvexMeshGeometry(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param mesh    WebIDL type: {@link PxConvexMesh}
     * @return Stack allocated object of PxConvexMeshGeometry
     */
    public static PxConvexMeshGeometry createAt(long address, PxConvexMesh mesh) {
        __placement_new_PxConvexMeshGeometry(address, mesh.getAddress());
        PxConvexMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param mesh      WebIDL type: {@link PxConvexMesh}
     * @return Stack allocated object of PxConvexMeshGeometry
     */
    public static <T> PxConvexMeshGeometry createAt(T allocator, Allocator<T> allocate, PxConvexMesh mesh) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxConvexMeshGeometry(address, mesh.getAddress());
        PxConvexMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxConvexMeshGeometry(long address, long mesh);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param mesh    WebIDL type: {@link PxConvexMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @return Stack allocated object of PxConvexMeshGeometry
     */
    public static PxConvexMeshGeometry createAt(long address, PxConvexMesh mesh, PxMeshScale scaling) {
        __placement_new_PxConvexMeshGeometry(address, mesh.getAddress(), scaling.getAddress());
        PxConvexMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param mesh      WebIDL type: {@link PxConvexMesh}
     * @param scaling   WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @return Stack allocated object of PxConvexMeshGeometry
     */
    public static <T> PxConvexMeshGeometry createAt(T allocator, Allocator<T> allocate, PxConvexMesh mesh, PxMeshScale scaling) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxConvexMeshGeometry(address, mesh.getAddress(), scaling.getAddress());
        PxConvexMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxConvexMeshGeometry(long address, long mesh, long scaling);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param mesh    WebIDL type: {@link PxConvexMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @param flags   WebIDL type: {@link PxConvexMeshGeometryFlags} [Ref]
     * @return Stack allocated object of PxConvexMeshGeometry
     */
    public static PxConvexMeshGeometry createAt(long address, PxConvexMesh mesh, PxMeshScale scaling, PxConvexMeshGeometryFlags flags) {
        __placement_new_PxConvexMeshGeometry(address, mesh.getAddress(), scaling.getAddress(), flags.getAddress());
        PxConvexMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param mesh      WebIDL type: {@link PxConvexMesh}
     * @param scaling   WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @param flags     WebIDL type: {@link PxConvexMeshGeometryFlags} [Ref]
     * @return Stack allocated object of PxConvexMeshGeometry
     */
    public static <T> PxConvexMeshGeometry createAt(T allocator, Allocator<T> allocate, PxConvexMesh mesh, PxMeshScale scaling, PxConvexMeshGeometryFlags flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxConvexMeshGeometry(address, mesh.getAddress(), scaling.getAddress(), flags.getAddress());
        PxConvexMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxConvexMeshGeometry(long address, long mesh, long scaling, long flags);

    // Constructors

    /**
     * @param mesh WebIDL type: {@link PxConvexMesh}
     */
    public PxConvexMeshGeometry(PxConvexMesh mesh) {
        address = _PxConvexMeshGeometry(mesh.getAddress());
    }
    private static native long _PxConvexMeshGeometry(long mesh);

    /**
     * @param mesh    WebIDL type: {@link PxConvexMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     */
    public PxConvexMeshGeometry(PxConvexMesh mesh, PxMeshScale scaling) {
        address = _PxConvexMeshGeometry(mesh.getAddress(), scaling.getAddress());
    }
    private static native long _PxConvexMeshGeometry(long mesh, long scaling);

    /**
     * @param mesh    WebIDL type: {@link PxConvexMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @param flags   WebIDL type: {@link PxConvexMeshGeometryFlags} [Ref]
     */
    public PxConvexMeshGeometry(PxConvexMesh mesh, PxMeshScale scaling, PxConvexMeshGeometryFlags flags) {
        address = _PxConvexMeshGeometry(mesh.getAddress(), scaling.getAddress(), flags.getAddress());
    }
    private static native long _PxConvexMeshGeometry(long mesh, long scaling, long flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxMeshScale} [Value]
     */
    public PxMeshScale getScale() {
        checkNotNull();
        return PxMeshScale.wrapPointer(_getScale(address));
    }
    private static native long _getScale(long address);

    /**
     * @param value WebIDL type: {@link PxMeshScale} [Value]
     */
    public void setScale(PxMeshScale value) {
        checkNotNull();
        _setScale(address, value.getAddress());
    }
    private static native void _setScale(long address, long value);

    /**
     * @return WebIDL type: {@link PxConvexMesh}
     */
    public PxConvexMesh getConvexMesh() {
        checkNotNull();
        return PxConvexMesh.wrapPointer(_getConvexMesh(address));
    }
    private static native long _getConvexMesh(long address);

    /**
     * @param value WebIDL type: {@link PxConvexMesh}
     */
    public void setConvexMesh(PxConvexMesh value) {
        checkNotNull();
        _setConvexMesh(address, value.getAddress());
    }
    private static native void _setConvexMesh(long address, long value);

    /**
     * @return WebIDL type: {@link PxConvexMeshGeometryFlags} [Value]
     */
    public PxConvexMeshGeometryFlags getMeshFlags() {
        checkNotNull();
        return PxConvexMeshGeometryFlags.wrapPointer(_getMeshFlags(address));
    }
    private static native long _getMeshFlags(long address);

    /**
     * @param value WebIDL type: {@link PxConvexMeshGeometryFlags} [Value]
     */
    public void setMeshFlags(PxConvexMeshGeometryFlags value) {
        checkNotNull();
        _setMeshFlags(address, value.getAddress());
    }
    private static native void _setMeshFlags(long address, long value);

}
