package physx.geometry;

import physx.NativeObject;
import physx.common.PxStridedData;

public class PxHeightFieldDesc extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxHeightFieldDesc wrapPointer(long address) {
        return address != 0L ? new PxHeightFieldDesc(address) : null;
    }
    
    public static PxHeightFieldDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxHeightFieldDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxHeightFieldDesc
     */
    public static PxHeightFieldDesc createAt(long address) {
        __placement_new_PxHeightFieldDesc(address);
        PxHeightFieldDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxHeightFieldDesc
     */
    public static <T> PxHeightFieldDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxHeightFieldDesc(address);
        PxHeightFieldDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxHeightFieldDesc(long address);

    // Constructors

    public PxHeightFieldDesc() {
        address = _PxHeightFieldDesc();
    }
    private static native long _PxHeightFieldDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbRows() {
        checkNotNull();
        return _getNbRows(address);
    }
    private static native int _getNbRows(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbRows(int value) {
        checkNotNull();
        _setNbRows(address, value);
    }
    private static native void _setNbRows(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbColumns() {
        checkNotNull();
        return _getNbColumns(address);
    }
    private static native int _getNbColumns(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbColumns(int value) {
        checkNotNull();
        _setNbColumns(address, value);
    }
    private static native void _setNbColumns(long address, int value);

    /**
     * @return WebIDL type: {@link PxHeightFieldFormatEnum} [enum]
     */
    public PxHeightFieldFormatEnum getFormat() {
        checkNotNull();
        return PxHeightFieldFormatEnum.forValue(_getFormat(address));
    }
    private static native int _getFormat(long address);

    /**
     * @param value WebIDL type: {@link PxHeightFieldFormatEnum} [enum]
     */
    public void setFormat(PxHeightFieldFormatEnum value) {
        checkNotNull();
        _setFormat(address, value.value);
    }
    private static native void _setFormat(long address, int value);

    /**
     * @return WebIDL type: {@link PxStridedData} [Value]
     */
    public PxStridedData getSamples() {
        checkNotNull();
        return PxStridedData.wrapPointer(_getSamples(address));
    }
    private static native long _getSamples(long address);

    /**
     * @param value WebIDL type: {@link PxStridedData} [Value]
     */
    public void setSamples(PxStridedData value) {
        checkNotNull();
        _setSamples(address, value.getAddress());
    }
    private static native void _setSamples(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getConvexEdgeThreshold() {
        checkNotNull();
        return _getConvexEdgeThreshold(address);
    }
    private static native float _getConvexEdgeThreshold(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setConvexEdgeThreshold(float value) {
        checkNotNull();
        _setConvexEdgeThreshold(address, value);
    }
    private static native void _setConvexEdgeThreshold(long address, float value);

    /**
     * @return WebIDL type: {@link PxHeightFieldFlags} [Value]
     */
    public PxHeightFieldFlags getFlags() {
        checkNotNull();
        return PxHeightFieldFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxHeightFieldFlags} [Value]
     */
    public void setFlags(PxHeightFieldFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
