package physx.geometry;


public class PxHeightFieldGeometry extends PxGeometry {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxHeightFieldGeometry wrapPointer(long address) {
        return address != 0L ? new PxHeightFieldGeometry(address) : null;
    }
    
    public static PxHeightFieldGeometry arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxHeightFieldGeometry(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxHeightFieldGeometry
     */
    public static PxHeightFieldGeometry createAt(long address) {
        __placement_new_PxHeightFieldGeometry(address);
        PxHeightFieldGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxHeightFieldGeometry
     */
    public static <T> PxHeightFieldGeometry createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxHeightFieldGeometry(address);
        PxHeightFieldGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxHeightFieldGeometry(long address);

    /**
     * @param address     Pre-allocated memory, where the object is created.
     * @param hf          WebIDL type: {@link PxHeightField}
     * @param flags       WebIDL type: {@link PxMeshGeometryFlags} [Ref]
     * @param heightScale WebIDL type: float
     * @param rowScale    WebIDL type: float
     * @param columnScale WebIDL type: float
     * @return Stack allocated object of PxHeightFieldGeometry
     */
    public static PxHeightFieldGeometry createAt(long address, PxHeightField hf, PxMeshGeometryFlags flags, float heightScale, float rowScale, float columnScale) {
        __placement_new_PxHeightFieldGeometry(address, hf.getAddress(), flags.getAddress(), heightScale, rowScale, columnScale);
        PxHeightFieldGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>         Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator   Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate    Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param hf          WebIDL type: {@link PxHeightField}
     * @param flags       WebIDL type: {@link PxMeshGeometryFlags} [Ref]
     * @param heightScale WebIDL type: float
     * @param rowScale    WebIDL type: float
     * @param columnScale WebIDL type: float
     * @return Stack allocated object of PxHeightFieldGeometry
     */
    public static <T> PxHeightFieldGeometry createAt(T allocator, Allocator<T> allocate, PxHeightField hf, PxMeshGeometryFlags flags, float heightScale, float rowScale, float columnScale) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxHeightFieldGeometry(address, hf.getAddress(), flags.getAddress(), heightScale, rowScale, columnScale);
        PxHeightFieldGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxHeightFieldGeometry(long address, long hf, long flags, float heightScale, float rowScale, float columnScale);

    // Constructors

    public PxHeightFieldGeometry() {
        address = _PxHeightFieldGeometry();
    }
    private static native long _PxHeightFieldGeometry();

    /**
     * @param hf          WebIDL type: {@link PxHeightField}
     * @param flags       WebIDL type: {@link PxMeshGeometryFlags} [Ref]
     * @param heightScale WebIDL type: float
     * @param rowScale    WebIDL type: float
     * @param columnScale WebIDL type: float
     */
    public PxHeightFieldGeometry(PxHeightField hf, PxMeshGeometryFlags flags, float heightScale, float rowScale, float columnScale) {
        address = _PxHeightFieldGeometry(hf.getAddress(), flags.getAddress(), heightScale, rowScale, columnScale);
    }
    private static native long _PxHeightFieldGeometry(long hf, long flags, float heightScale, float rowScale, float columnScale);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxHeightField}
     */
    public PxHeightField getHeightField() {
        checkNotNull();
        return PxHeightField.wrapPointer(_getHeightField(address));
    }
    private static native long _getHeightField(long address);

    /**
     * @param value WebIDL type: {@link PxHeightField}
     */
    public void setHeightField(PxHeightField value) {
        checkNotNull();
        _setHeightField(address, value.getAddress());
    }
    private static native void _setHeightField(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getHeightScale() {
        checkNotNull();
        return _getHeightScale(address);
    }
    private static native float _getHeightScale(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setHeightScale(float value) {
        checkNotNull();
        _setHeightScale(address, value);
    }
    private static native void _setHeightScale(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getRowScale() {
        checkNotNull();
        return _getRowScale(address);
    }
    private static native float _getRowScale(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRowScale(float value) {
        checkNotNull();
        _setRowScale(address, value);
    }
    private static native void _setRowScale(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getColumnScale() {
        checkNotNull();
        return _getColumnScale(address);
    }
    private static native float _getColumnScale(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setColumnScale(float value) {
        checkNotNull();
        _setColumnScale(address, value);
    }
    private static native void _setColumnScale(long address, float value);

    /**
     * @return WebIDL type: {@link PxMeshGeometryFlags} [Value]
     */
    public PxMeshGeometryFlags getHeightFieldFlags() {
        checkNotNull();
        return PxMeshGeometryFlags.wrapPointer(_getHeightFieldFlags(address));
    }
    private static native long _getHeightFieldFlags(long address);

    /**
     * @param value WebIDL type: {@link PxMeshGeometryFlags} [Value]
     */
    public void setHeightFieldFlags(PxMeshGeometryFlags value) {
        checkNotNull();
        _setHeightFieldFlags(address, value.getAddress());
    }
    private static native void _setHeightFieldFlags(long address, long value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
