package physx.geometry;

import physx.NativeObject;
import physx.common.PxQuat;
import physx.common.PxVec3;

public class PxMeshScale extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxMeshScale wrapPointer(long address) {
        return address != 0L ? new PxMeshScale(address) : null;
    }
    
    public static PxMeshScale arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxMeshScale(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxMeshScale
     */
    public static PxMeshScale createAt(long address) {
        __placement_new_PxMeshScale(address);
        PxMeshScale createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxMeshScale
     */
    public static <T> PxMeshScale createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxMeshScale(address);
        PxMeshScale createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxMeshScale(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param r       WebIDL type: float
     * @return Stack allocated object of PxMeshScale
     */
    public static PxMeshScale createAt(long address, float r) {
        __placement_new_PxMeshScale(address, r);
        PxMeshScale createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param r         WebIDL type: float
     * @return Stack allocated object of PxMeshScale
     */
    public static <T> PxMeshScale createAt(T allocator, Allocator<T> allocate, float r) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxMeshScale(address, r);
        PxMeshScale createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxMeshScale(long address, float r);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param s       WebIDL type: {@link PxVec3} [Const, Ref]
     * @param r       WebIDL type: {@link PxQuat} [Const, Ref]
     * @return Stack allocated object of PxMeshScale
     */
    public static PxMeshScale createAt(long address, PxVec3 s, PxQuat r) {
        __placement_new_PxMeshScale(address, s.getAddress(), r.getAddress());
        PxMeshScale createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param s         WebIDL type: {@link PxVec3} [Const, Ref]
     * @param r         WebIDL type: {@link PxQuat} [Const, Ref]
     * @return Stack allocated object of PxMeshScale
     */
    public static <T> PxMeshScale createAt(T allocator, Allocator<T> allocate, PxVec3 s, PxQuat r) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxMeshScale(address, s.getAddress(), r.getAddress());
        PxMeshScale createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxMeshScale(long address, long s, long r);

    // Constructors

    public PxMeshScale() {
        address = _PxMeshScale();
    }
    private static native long _PxMeshScale();

    /**
     * @param r WebIDL type: float
     */
    public PxMeshScale(float r) {
        address = _PxMeshScale(r);
    }
    private static native long _PxMeshScale(float r);

    /**
     * @param s WebIDL type: {@link PxVec3} [Const, Ref]
     * @param r WebIDL type: {@link PxQuat} [Const, Ref]
     */
    public PxMeshScale(PxVec3 s, PxQuat r) {
        address = _PxMeshScale(s.getAddress(), r.getAddress());
    }
    private static native long _PxMeshScale(long s, long r);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
