package physx.geometry;

import physx.NativeObject;
import physx.common.PxBoundedData;

public class PxSimpleTriangleMesh extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSimpleTriangleMesh wrapPointer(long address) {
        return address != 0L ? new PxSimpleTriangleMesh(address) : null;
    }
    
    public static PxSimpleTriangleMesh arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSimpleTriangleMesh(long address) {
        super(address);
    }

    // Constructors

    public PxSimpleTriangleMesh() {
        address = _PxSimpleTriangleMesh();
    }
    private static native long _PxSimpleTriangleMesh();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxBoundedData} [Value]
     */
    public PxBoundedData getPoints() {
        checkNotNull();
        return PxBoundedData.wrapPointer(_getPoints(address));
    }
    private static native long _getPoints(long address);

    /**
     * @param value WebIDL type: {@link PxBoundedData} [Value]
     */
    public void setPoints(PxBoundedData value) {
        checkNotNull();
        _setPoints(address, value.getAddress());
    }
    private static native void _setPoints(long address, long value);

    /**
     * @return WebIDL type: {@link PxBoundedData} [Value]
     */
    public PxBoundedData getTriangles() {
        checkNotNull();
        return PxBoundedData.wrapPointer(_getTriangles(address));
    }
    private static native long _getTriangles(long address);

    /**
     * @param value WebIDL type: {@link PxBoundedData} [Value]
     */
    public void setTriangles(PxBoundedData value) {
        checkNotNull();
        _setTriangles(address, value.getAddress());
    }
    private static native void _setTriangles(long address, long value);

    /**
     * @return WebIDL type: {@link PxMeshFlags} [Value]
     */
    public PxMeshFlags getFlags() {
        checkNotNull();
        return PxMeshFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxMeshFlags} [Value]
     */
    public void setFlags(PxMeshFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
