package physx.geometry;

import physx.NativeObject;
import physx.common.PxBounds3;
import physx.common.PxRefCounted;
import physx.common.PxVec3;
import physx.support.PxU32ConstPtr;

public class PxTriangleMesh extends PxRefCounted {

    protected PxTriangleMesh() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxTriangleMesh wrapPointer(long address) {
        return address != 0L ? new PxTriangleMesh(address) : null;
    }
    
    public static PxTriangleMesh arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxTriangleMesh(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbVertices() {
        checkNotNull();
        return _getNbVertices(address);
    }
    private static native int _getNbVertices(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Const]
     */
    public PxVec3 getVertices() {
        checkNotNull();
        return PxVec3.wrapPointer(_getVertices(address));
    }
    private static native long _getVertices(long address);

    /**
     * @return WebIDL type: {@link PxVec3}
     */
    public PxVec3 getVerticesForModification() {
        checkNotNull();
        return PxVec3.wrapPointer(_getVerticesForModification(address));
    }
    private static native long _getVerticesForModification(long address);

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 refitBVH() {
        checkNotNull();
        return PxBounds3.wrapPointer(_refitBVH(address));
    }
    private static native long _refitBVH(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbTriangles() {
        checkNotNull();
        return _getNbTriangles(address);
    }
    private static native int _getNbTriangles(long address);

    /**
     * @return WebIDL type: VoidPtr [Const]
     */
    public NativeObject getTriangles() {
        checkNotNull();
        return NativeObject.wrapPointer(_getTriangles(address));
    }
    private static native long _getTriangles(long address);

    /**
     * @return WebIDL type: {@link PxTriangleMeshFlags} [Value]
     */
    public PxTriangleMeshFlags getTriangleMeshFlags() {
        checkNotNull();
        return PxTriangleMeshFlags.wrapPointer(_getTriangleMeshFlags(address));
    }
    private static native long _getTriangleMeshFlags(long address);

    /**
     * @return WebIDL type: {@link PxU32ConstPtr} [Const, Value]
     */
    public PxU32ConstPtr getTrianglesRemap() {
        checkNotNull();
        return PxU32ConstPtr.wrapPointer(_getTrianglesRemap(address));
    }
    private static native long _getTrianglesRemap(long address);

    /**
     * @param triangleIndex WebIDL type: unsigned long
     * @return WebIDL type: unsigned short
     */
    public short getTriangleMaterialIndex(int triangleIndex) {
        checkNotNull();
        return _getTriangleMaterialIndex(address, triangleIndex);
    }
    private static native short _getTriangleMaterialIndex(long address, int triangleIndex);

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getLocalBounds() {
        checkNotNull();
        return PxBounds3.wrapPointer(_getLocalBounds(address));
    }
    private static native long _getLocalBounds(long address);

}
