package physx.geometry;


public class PxTriangleMeshGeometry extends PxGeometry {

    protected PxTriangleMeshGeometry() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxTriangleMeshGeometry wrapPointer(long address) {
        return address != 0L ? new PxTriangleMeshGeometry(address) : null;
    }
    
    public static PxTriangleMeshGeometry arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxTriangleMeshGeometry(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param mesh    WebIDL type: {@link PxTriangleMesh}
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static PxTriangleMeshGeometry createAt(long address, PxTriangleMesh mesh) {
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param mesh      WebIDL type: {@link PxTriangleMesh}
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static <T> PxTriangleMeshGeometry createAt(T allocator, Allocator<T> allocate, PxTriangleMesh mesh) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTriangleMeshGeometry(long address, long mesh);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param mesh    WebIDL type: {@link PxTriangleMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static PxTriangleMeshGeometry createAt(long address, PxTriangleMesh mesh, PxMeshScale scaling) {
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress(), scaling.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param mesh      WebIDL type: {@link PxTriangleMesh}
     * @param scaling   WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static <T> PxTriangleMeshGeometry createAt(T allocator, Allocator<T> allocate, PxTriangleMesh mesh, PxMeshScale scaling) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress(), scaling.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTriangleMeshGeometry(long address, long mesh, long scaling);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param mesh    WebIDL type: {@link PxTriangleMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @param flags   WebIDL type: {@link PxMeshGeometryFlags} [Ref]
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static PxTriangleMeshGeometry createAt(long address, PxTriangleMesh mesh, PxMeshScale scaling, PxMeshGeometryFlags flags) {
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress(), scaling.getAddress(), flags.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param mesh      WebIDL type: {@link PxTriangleMesh}
     * @param scaling   WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @param flags     WebIDL type: {@link PxMeshGeometryFlags} [Ref]
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static <T> PxTriangleMeshGeometry createAt(T allocator, Allocator<T> allocate, PxTriangleMesh mesh, PxMeshScale scaling, PxMeshGeometryFlags flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress(), scaling.getAddress(), flags.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTriangleMeshGeometry(long address, long mesh, long scaling, long flags);

    // Constructors

    /**
     * @param mesh WebIDL type: {@link PxTriangleMesh}
     */
    public PxTriangleMeshGeometry(PxTriangleMesh mesh) {
        address = _PxTriangleMeshGeometry(mesh.getAddress());
    }
    private static native long _PxTriangleMeshGeometry(long mesh);

    /**
     * @param mesh    WebIDL type: {@link PxTriangleMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     */
    public PxTriangleMeshGeometry(PxTriangleMesh mesh, PxMeshScale scaling) {
        address = _PxTriangleMeshGeometry(mesh.getAddress(), scaling.getAddress());
    }
    private static native long _PxTriangleMeshGeometry(long mesh, long scaling);

    /**
     * @param mesh    WebIDL type: {@link PxTriangleMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @param flags   WebIDL type: {@link PxMeshGeometryFlags} [Ref]
     */
    public PxTriangleMeshGeometry(PxTriangleMesh mesh, PxMeshScale scaling, PxMeshGeometryFlags flags) {
        address = _PxTriangleMeshGeometry(mesh.getAddress(), scaling.getAddress(), flags.getAddress());
    }
    private static native long _PxTriangleMeshGeometry(long mesh, long scaling, long flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxMeshScale} [Value]
     */
    public PxMeshScale getScale() {
        checkNotNull();
        return PxMeshScale.wrapPointer(_getScale(address));
    }
    private static native long _getScale(long address);

    /**
     * @param value WebIDL type: {@link PxMeshScale} [Value]
     */
    public void setScale(PxMeshScale value) {
        checkNotNull();
        _setScale(address, value.getAddress());
    }
    private static native void _setScale(long address, long value);

    /**
     * @return WebIDL type: {@link PxMeshGeometryFlags} [Value]
     */
    public PxMeshGeometryFlags getMeshFlags() {
        checkNotNull();
        return PxMeshGeometryFlags.wrapPointer(_getMeshFlags(address));
    }
    private static native long _getMeshFlags(long address);

    /**
     * @param value WebIDL type: {@link PxMeshGeometryFlags} [Value]
     */
    public void setMeshFlags(PxMeshGeometryFlags value) {
        checkNotNull();
        _setMeshFlags(address, value.getAddress());
    }
    private static native void _setMeshFlags(long address, long value);

    /**
     * @return WebIDL type: {@link PxTriangleMesh}
     */
    public PxTriangleMesh getTriangleMesh() {
        checkNotNull();
        return PxTriangleMesh.wrapPointer(_getTriangleMesh(address));
    }
    private static native long _getTriangleMesh(long address);

    /**
     * @param value WebIDL type: {@link PxTriangleMesh}
     */
    public void setTriangleMesh(PxTriangleMesh value) {
        checkNotNull();
        _setTriangleMesh(address, value.getAddress());
    }
    private static native void _setTriangleMesh(long address, long value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
