package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxDiffuseParticleParams extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxDiffuseParticleParams");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxDiffuseParticleParams wrapPointer(long address) {
        return address != 0L ? new PxDiffuseParticleParams(address) : null;
    }
    
    public static PxDiffuseParticleParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxDiffuseParticleParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxDiffuseParticleParams
     */
    public static PxDiffuseParticleParams createAt(long address) {
        __placement_new_PxDiffuseParticleParams(address);
        PxDiffuseParticleParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxDiffuseParticleParams
     */
    public static <T> PxDiffuseParticleParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxDiffuseParticleParams(address);
        PxDiffuseParticleParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxDiffuseParticleParams(long address);

    // Constructors

    public PxDiffuseParticleParams() {
        address = _PxDiffuseParticleParams();
    }
    private static native long _PxDiffuseParticleParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getThreshold() {
        checkNotNull();
        return _getThreshold(address);
    }
    private static native float _getThreshold(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setThreshold(float value) {
        checkNotNull();
        _setThreshold(address, value);
    }
    private static native void _setThreshold(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getLifetime() {
        checkNotNull();
        return _getLifetime(address);
    }
    private static native float _getLifetime(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLifetime(float value) {
        checkNotNull();
        _setLifetime(address, value);
    }
    private static native void _setLifetime(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getAirDrag() {
        checkNotNull();
        return _getAirDrag(address);
    }
    private static native float _getAirDrag(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setAirDrag(float value) {
        checkNotNull();
        _setAirDrag(address, value);
    }
    private static native void _setAirDrag(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getBubbleDrag() {
        checkNotNull();
        return _getBubbleDrag(address);
    }
    private static native float _getBubbleDrag(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setBubbleDrag(float value) {
        checkNotNull();
        _setBubbleDrag(address, value);
    }
    private static native void _setBubbleDrag(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getBuoyancy() {
        checkNotNull();
        return _getBuoyancy(address);
    }
    private static native float _getBuoyancy(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setBuoyancy(float value) {
        checkNotNull();
        _setBuoyancy(address, value);
    }
    private static native void _setBuoyancy(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getKineticEnergyWeight() {
        checkNotNull();
        return _getKineticEnergyWeight(address);
    }
    private static native float _getKineticEnergyWeight(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setKineticEnergyWeight(float value) {
        checkNotNull();
        _setKineticEnergyWeight(address, value);
    }
    private static native void _setKineticEnergyWeight(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getPressureWeight() {
        checkNotNull();
        return _getPressureWeight(address);
    }
    private static native float _getPressureWeight(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setPressureWeight(float value) {
        checkNotNull();
        _setPressureWeight(address, value);
    }
    private static native void _setPressureWeight(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDivergenceWeight() {
        checkNotNull();
        return _getDivergenceWeight(address);
    }
    private static native float _getDivergenceWeight(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDivergenceWeight(float value) {
        checkNotNull();
        _setDivergenceWeight(address, value);
    }
    private static native void _setDivergenceWeight(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getCollisionDecay() {
        checkNotNull();
        return _getCollisionDecay(address);
    }
    private static native float _getCollisionDecay(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setCollisionDecay(float value) {
        checkNotNull();
        _setCollisionDecay(address, value);
    }
    private static native void _setCollisionDecay(long address, float value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getUseAccurateVelocity() {
        checkNotNull();
        return _getUseAccurateVelocity(address);
    }
    private static native boolean _getUseAccurateVelocity(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setUseAccurateVelocity(boolean value) {
        checkNotNull();
        _setUseAccurateVelocity(address, value);
    }
    private static native void _setUseAccurateVelocity(long address, boolean value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
