package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.support.PxU32Ptr;

public class PxGpuParticleSystem extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxGpuParticleSystem");
    }

    protected PxGpuParticleSystem() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxGpuParticleSystem wrapPointer(long address) {
        return address != 0L ? new PxGpuParticleSystem(address) : null;
    }
    
    public static PxGpuParticleSystem arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxGpuParticleSystem(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public PxU32Ptr getMUnsortedPhaseArray() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getMUnsortedPhaseArray(address));
    }
    private static native long _getMUnsortedPhaseArray(long address);

    /**
     * @param value WebIDL type: {@link PxU32Ptr} [Value]
     */
    public void setMUnsortedPhaseArray(PxU32Ptr value) {
        checkNotNull();
        _setMUnsortedPhaseArray(address, value.getAddress());
    }
    private static native void _setMUnsortedPhaseArray(long address, long value);

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public PxU32Ptr getMSortedPhaseArray() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getMSortedPhaseArray(address));
    }
    private static native long _getMSortedPhaseArray(long address);

    /**
     * @param value WebIDL type: {@link PxU32Ptr} [Value]
     */
    public void setMSortedPhaseArray(PxU32Ptr value) {
        checkNotNull();
        _setMSortedPhaseArray(address, value.getAddress());
    }
    private static native void _setMSortedPhaseArray(long address, long value);

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public PxU32Ptr getMUnsortedToSortedMapping() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getMUnsortedToSortedMapping(address));
    }
    private static native long _getMUnsortedToSortedMapping(long address);

    /**
     * @param value WebIDL type: {@link PxU32Ptr} [Value]
     */
    public void setMUnsortedToSortedMapping(PxU32Ptr value) {
        checkNotNull();
        _setMUnsortedToSortedMapping(address, value.getAddress());
    }
    private static native void _setMUnsortedToSortedMapping(long address, long value);

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public PxU32Ptr getMSortedToUnsortedMapping() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getMSortedToUnsortedMapping(address));
    }
    private static native long _getMSortedToUnsortedMapping(long address);

    /**
     * @param value WebIDL type: {@link PxU32Ptr} [Value]
     */
    public void setMSortedToUnsortedMapping(PxU32Ptr value) {
        checkNotNull();
        _setMSortedToUnsortedMapping(address, value.getAddress());
    }
    private static native void _setMSortedToUnsortedMapping(long address, long value);

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public PxU32Ptr getMParticleSelfCollisionCount() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getMParticleSelfCollisionCount(address));
    }
    private static native long _getMParticleSelfCollisionCount(long address);

    /**
     * @param value WebIDL type: {@link PxU32Ptr} [Value]
     */
    public void setMParticleSelfCollisionCount(PxU32Ptr value) {
        checkNotNull();
        _setMParticleSelfCollisionCount(address, value.getAddress());
    }
    private static native void _setMParticleSelfCollisionCount(long address, long value);

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public PxU32Ptr getMCollisionIndex() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getMCollisionIndex(address));
    }
    private static native long _getMCollisionIndex(long address);

    /**
     * @param value WebIDL type: {@link PxU32Ptr} [Value]
     */
    public void setMCollisionIndex(PxU32Ptr value) {
        checkNotNull();
        _setMCollisionIndex(address, value.getAddress());
    }
    private static native void _setMCollisionIndex(long address, long value);

    // Functions

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNumCells() {
        checkNotNull();
        return _getNumCells(address);
    }
    private static native int _getNumCells(long address);

}
