package physx.particles;

import physx.PlatformChecks;

public class PxPBDMaterial extends PxParticleMaterial {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxPBDMaterial");
    }

    protected PxPBDMaterial() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxPBDMaterial wrapPointer(long address) {
        return address != 0L ? new PxPBDMaterial(address) : null;
    }
    
    public static PxPBDMaterial arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxPBDMaterial(long address) {
        super(address);
    }

    // Functions

    /**
     * @param viscosity WebIDL type: float
     */
    public void setViscosity(float viscosity) {
        checkNotNull();
        _setViscosity(address, viscosity);
    }
    private static native void _setViscosity(long address, float viscosity);

    /**
     * @return WebIDL type: float
     */
    public float getViscosity() {
        checkNotNull();
        return _getViscosity(address);
    }
    private static native float _getViscosity(long address);

    /**
     * @param vorticityConfinement WebIDL type: float
     */
    public void setVorticityConfinement(float vorticityConfinement) {
        checkNotNull();
        _setVorticityConfinement(address, vorticityConfinement);
    }
    private static native void _setVorticityConfinement(long address, float vorticityConfinement);

    /**
     * @return WebIDL type: float
     */
    public float getVorticityConfinement() {
        checkNotNull();
        return _getVorticityConfinement(address);
    }
    private static native float _getVorticityConfinement(long address);

    /**
     * @param surfaceTension WebIDL type: float
     */
    public void setSurfaceTension(float surfaceTension) {
        checkNotNull();
        _setSurfaceTension(address, surfaceTension);
    }
    private static native void _setSurfaceTension(long address, float surfaceTension);

    /**
     * @return WebIDL type: float
     */
    public float getSurfaceTension() {
        checkNotNull();
        return _getSurfaceTension(address);
    }
    private static native float _getSurfaceTension(long address);

    /**
     * @param cohesion WebIDL type: float
     */
    public void setCohesion(float cohesion) {
        checkNotNull();
        _setCohesion(address, cohesion);
    }
    private static native void _setCohesion(long address, float cohesion);

    /**
     * @return WebIDL type: float
     */
    public float getCohesion() {
        checkNotNull();
        return _getCohesion(address);
    }
    private static native float _getCohesion(long address);

    /**
     * @param lift WebIDL type: float
     */
    public void setLift(float lift) {
        checkNotNull();
        _setLift(address, lift);
    }
    private static native void _setLift(long address, float lift);

    /**
     * @return WebIDL type: float
     */
    public float getLift() {
        checkNotNull();
        return _getLift(address);
    }
    private static native float _getLift(long address);

    /**
     * @param drag WebIDL type: float
     */
    public void setDrag(float drag) {
        checkNotNull();
        _setDrag(address, drag);
    }
    private static native void _setDrag(long address, float drag);

    /**
     * @return WebIDL type: float
     */
    public float getDrag() {
        checkNotNull();
        return _getDrag(address);
    }
    private static native float _getDrag(long address);

    /**
     * @param coefficient WebIDL type: float
     */
    public void setCFLCoefficient(float coefficient) {
        checkNotNull();
        _setCFLCoefficient(address, coefficient);
    }
    private static native void _setCFLCoefficient(long address, float coefficient);

    /**
     * @return WebIDL type: float
     */
    public float getCFLCoefficient() {
        checkNotNull();
        return _getCFLCoefficient(address);
    }
    private static native float _getCFLCoefficient(long address);

    /**
     * @param scale WebIDL type: float
     */
    public void setParticleFrictionScale(float scale) {
        checkNotNull();
        _setParticleFrictionScale(address, scale);
    }
    private static native void _setParticleFrictionScale(long address, float scale);

    /**
     * @return WebIDL type: float
     */
    public float getParticleFrictionScale() {
        checkNotNull();
        return _getParticleFrictionScale(address);
    }
    private static native float _getParticleFrictionScale(long address);

    /**
     * @param adhesion WebIDL type: float
     */
    public void setParticleAdhesionScale(float adhesion) {
        checkNotNull();
        _setParticleAdhesionScale(address, adhesion);
    }
    private static native void _setParticleAdhesionScale(long address, float adhesion);

    /**
     * @return WebIDL type: float
     */
    public float getParticleAdhesionScale() {
        checkNotNull();
        return _getParticleAdhesionScale(address);
    }
    private static native float _getParticleAdhesionScale(long address);

    /**
     * @return WebIDL type: DOMString
     */
    public String getConcreteTypeName() {
        checkNotNull();
        return _getConcreteTypeName(address);
    }
    private static native String _getConcreteTypeName(long address);

}
