package physx.particles;

import physx.PlatformChecks;
import physx.common.PxVec3;

public class PxPBDParticleSystem extends PxParticleSystem {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxPBDParticleSystem");
    }

    protected PxPBDParticleSystem() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxPBDParticleSystem wrapPointer(long address) {
        return address != 0L ? new PxPBDParticleSystem(address) : null;
    }
    
    public static PxPBDParticleSystem arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxPBDParticleSystem(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param wind WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setWind(PxVec3 wind) {
        checkNotNull();
        _setWind(address, wind.getAddress());
    }
    private static native void _setWind(long address, long wind);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getWind() {
        checkNotNull();
        return PxVec3.wrapPointer(_getWind(address));
    }
    private static native long _getWind(long address);

    /**
     * @param fluidBoundaryDensityScale WebIDL type: float
     */
    public void setFluidBoundaryDensityScale(float fluidBoundaryDensityScale) {
        checkNotNull();
        _setFluidBoundaryDensityScale(address, fluidBoundaryDensityScale);
    }
    private static native void _setFluidBoundaryDensityScale(long address, float fluidBoundaryDensityScale);

    /**
     * @return WebIDL type: float
     */
    public float getFluidBoundaryDensityScale() {
        checkNotNull();
        return _getFluidBoundaryDensityScale(address);
    }
    private static native float _getFluidBoundaryDensityScale(long address);

    /**
     * @param fluidRestOffset WebIDL type: float
     */
    public void setFluidRestOffset(float fluidRestOffset) {
        checkNotNull();
        _setFluidRestOffset(address, fluidRestOffset);
    }
    private static native void _setFluidRestOffset(long address, float fluidRestOffset);

    /**
     * @return WebIDL type: float
     */
    public float getFluidRestOffset() {
        checkNotNull();
        return _getFluidRestOffset(address);
    }
    private static native float _getFluidRestOffset(long address);

    /**
     * @param gridSizeX WebIDL type: unsigned long
     */
    public void setGridSizeX(int gridSizeX) {
        checkNotNull();
        _setGridSizeX(address, gridSizeX);
    }
    private static native void _setGridSizeX(long address, int gridSizeX);

    /**
     * @param gridSizeY WebIDL type: unsigned long
     */
    public void setGridSizeY(int gridSizeY) {
        checkNotNull();
        _setGridSizeY(address, gridSizeY);
    }
    private static native void _setGridSizeY(long address, int gridSizeY);

    /**
     * @param gridSizeZ WebIDL type: unsigned long
     */
    public void setGridSizeZ(int gridSizeZ) {
        checkNotNull();
        _setGridSizeZ(address, gridSizeZ);
    }
    private static native void _setGridSizeZ(long address, int gridSizeZ);

    /**
     * @return WebIDL type: DOMString
     */
    public String getConcreteTypeName() {
        checkNotNull();
        return _getConcreteTypeName(address);
    }
    private static native String _getConcreteTypeName(long address);

}
