package physx.particles;

import physx.PlatformChecks;
import physx.common.PxVec4;

public class PxParticleAndDiffuseBuffer extends PxParticleBuffer {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleAndDiffuseBuffer");
    }

    protected PxParticleAndDiffuseBuffer() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleAndDiffuseBuffer wrapPointer(long address) {
        return address != 0L ? new PxParticleAndDiffuseBuffer(address) : null;
    }
    
    public static PxParticleAndDiffuseBuffer arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleAndDiffuseBuffer(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: {@link PxVec4}
     */
    public PxVec4 getDiffusePositionLifeTime() {
        checkNotNull();
        return PxVec4.wrapPointer(_getDiffusePositionLifeTime(address));
    }
    private static native long _getDiffusePositionLifeTime(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbActiveDiffuseParticles() {
        checkNotNull();
        return _getNbActiveDiffuseParticles(address);
    }
    private static native int _getNbActiveDiffuseParticles(long address);

    /**
     * @param maxActiveDiffuseParticles WebIDL type: unsigned long
     */
    public void setMaxActiveDiffuseParticles(int maxActiveDiffuseParticles) {
        checkNotNull();
        _setMaxActiveDiffuseParticles(address, maxActiveDiffuseParticles);
    }
    private static native void _setMaxActiveDiffuseParticles(long address, int maxActiveDiffuseParticles);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxDiffuseParticles() {
        checkNotNull();
        return _getMaxDiffuseParticles(address);
    }
    private static native int _getMaxDiffuseParticles(long address);

    /**
     * @param params WebIDL type: {@link PxDiffuseParticleParams} [Const, Ref]
     */
    public void setDiffuseParticleParams(PxDiffuseParticleParams params) {
        checkNotNull();
        _setDiffuseParticleParams(address, params.getAddress());
    }
    private static native void _setDiffuseParticleParams(long address, long params);

    /**
     * @return WebIDL type: {@link PxDiffuseParticleParams} [Value]
     */
    public PxDiffuseParticleParams getDiffuseParticleParams() {
        checkNotNull();
        return PxDiffuseParticleParams.wrapPointer(_getDiffuseParticleParams(address));
    }
    private static native long _getDiffuseParticleParams(long address);

}
