package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxBase;
import physx.common.PxVec4;

public class PxParticleBuffer extends PxBase {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleBuffer");
    }

    protected PxParticleBuffer() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleBuffer wrapPointer(long address) {
        return address != 0L ? new PxParticleBuffer(address) : null;
    }
    
    public static PxParticleBuffer arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleBuffer(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getBufferIndex() {
        checkNotNull();
        return _getBufferIndex(address);
    }
    private static native int _getBufferIndex(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getBufferUniqueId() {
        checkNotNull();
        return _getBufferUniqueId(address);
    }
    private static native int _getBufferUniqueId(long address);

    // Functions

    /**
     * @return WebIDL type: {@link PxVec4}
     */
    public PxVec4 getPositionInvMasses() {
        checkNotNull();
        return PxVec4.wrapPointer(_getPositionInvMasses(address));
    }
    private static native long _getPositionInvMasses(long address);

    /**
     * @return WebIDL type: {@link PxVec4}
     */
    public PxVec4 getVelocities() {
        checkNotNull();
        return PxVec4.wrapPointer(_getVelocities(address));
    }
    private static native long _getVelocities(long address);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getPhases() {
        checkNotNull();
        return NativeObject.wrapPointer(_getPhases(address));
    }
    private static native long _getPhases(long address);

    /**
     * @return WebIDL type: {@link PxParticleVolume}
     */
    public PxParticleVolume getParticleVolumes() {
        checkNotNull();
        return PxParticleVolume.wrapPointer(_getParticleVolumes(address));
    }
    private static native long _getParticleVolumes(long address);

    /**
     * @param nbActiveParticles WebIDL type: unsigned long
     */
    public void setNbActiveParticles(int nbActiveParticles) {
        checkNotNull();
        _setNbActiveParticles(address, nbActiveParticles);
    }
    private static native void _setNbActiveParticles(long address, int nbActiveParticles);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbActiveParticles() {
        checkNotNull();
        return _getNbActiveParticles(address);
    }
    private static native int _getNbActiveParticles(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxParticles() {
        checkNotNull();
        return _getMaxParticles(address);
    }
    private static native int _getMaxParticles(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbParticleVolumes() {
        checkNotNull();
        return _getNbParticleVolumes(address);
    }
    private static native int _getNbParticleVolumes(long address);

    /**
     * @param nbParticleVolumes WebIDL type: unsigned long
     */
    public void setNbParticleVolumes(int nbParticleVolumes) {
        checkNotNull();
        _setNbParticleVolumes(address, nbParticleVolumes);
    }
    private static native void _setNbParticleVolumes(long address, int nbParticleVolumes);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxParticleVolumes() {
        checkNotNull();
        return _getMaxParticleVolumes(address);
    }
    private static native int _getMaxParticleVolumes(long address);

    /**
     * @param filters   WebIDL type: {@link PxParticleRigidFilterPair}
     * @param nbFilters WebIDL type: unsigned long
     */
    public void setRigidFilters(PxParticleRigidFilterPair filters, int nbFilters) {
        checkNotNull();
        _setRigidFilters(address, filters.getAddress(), nbFilters);
    }
    private static native void _setRigidFilters(long address, long filters, int nbFilters);

    /**
     * @param attachments   WebIDL type: {@link PxParticleRigidAttachment}
     * @param nbAttachments WebIDL type: unsigned long
     */
    public void setRigidAttachments(PxParticleRigidAttachment attachments, int nbAttachments) {
        checkNotNull();
        _setRigidAttachments(address, attachments.getAddress(), nbAttachments);
    }
    private static native void _setRigidAttachments(long address, long attachments, int nbAttachments);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFlatListStartIndex() {
        checkNotNull();
        return _getFlatListStartIndex(address);
    }
    private static native int _getFlatListStartIndex(long address);

    /**
     * @param flags WebIDL type: {@link PxParticleBufferFlagEnum} [enum]
     */
    public void raiseFlags(PxParticleBufferFlagEnum flags) {
        checkNotNull();
        _raiseFlags(address, flags.value);
    }
    private static native void _raiseFlags(long address, int flags);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

}
